/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.update.UpdateDocumentEdit;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceDocumentsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInTitle;
    private boolean findInDocAbstract;
    private boolean findInType;
    private boolean findInDoi;
    private boolean findInSourceIdentifier;
    private boolean findInVolume;
    private boolean findInIssue;
    private boolean findInBeginPage;
    private boolean findInEndPage;

    public GlobalReplaceDocumentsEdit(String findText, String replaceText, boolean findInTitle, boolean findInDocAbstract, boolean findInType, boolean findInDoi, boolean findInSourceIdentifier, boolean findInVolume, boolean findInIssue, boolean findInBeginPage, boolean findInEndPage) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInTitle = findInTitle;
        this.findInDocAbstract = findInDocAbstract;
        this.findInType = findInType;
        this.findInDoi = findInDoi;
        this.findInSourceIdentifier = findInSourceIdentifier;
        this.findInVolume = findInVolume;
        this.findInIssue = findInIssue;
        this.findInBeginPage = findInBeginPage;
        this.findInEndPage = findInEndPage;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
        try {
            ArrayList<Document> documents = documentDAO.getDocuments();
            for (int i = 0; i < documents.size(); ++i) {
                String endPage;
                String beginPage;
                String issue;
                String volume;
                String sourceIdentifier;
                String doi;
                String type;
                String docAbstract;
                String title;
                Document document = documents.get(i);
                if (this.findInTitle) {
                    title = document.getTitle().replaceAll(this.findText, this.replaceText);
                    updated = updated || !title.equals(document.getTitle());
                } else {
                    title = document.getTitle();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInDocAbstract) {
                    docAbstract = document.getDocAbstract().replaceAll(this.findText, this.replaceText);
                    updated = updated || !docAbstract.equals(document.getDocAbstract());
                } else {
                    docAbstract = document.getDocAbstract();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInType) {
                    type = document.getType().replaceAll(this.findText, this.replaceText);
                    updated = updated || !type.equals(document.getType());
                } else {
                    type = document.getType();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInDoi) {
                    doi = document.getDoi().replaceAll(this.findText, this.replaceText);
                    updated = updated || !doi.equals(document.getDoi());
                } else {
                    doi = document.getDoi();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInSourceIdentifier) {
                    sourceIdentifier = document.getSourceIdentifier().replaceAll(this.findText, this.replaceText);
                    updated = updated || !sourceIdentifier.equals(document.getSourceIdentifier());
                } else {
                    sourceIdentifier = document.getSourceIdentifier();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInVolume) {
                    volume = document.getVolume().replaceAll(this.findText, this.replaceText);
                    updated = updated || !volume.equals(document.getVolume());
                } else {
                    volume = document.getVolume();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInIssue) {
                    issue = document.getIssue().replaceAll(this.findText, this.replaceText);
                    updated = updated || !issue.equals(document.getIssue());
                } else {
                    issue = document.getIssue();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInBeginPage) {
                    beginPage = document.getBeginPage().replaceAll(this.findText, this.replaceText);
                    updated = updated || !beginPage.equals(document.getBeginPage());
                } else {
                    beginPage = document.getBeginPage();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInEndPage) {
                    endPage = document.getEndPage().replaceAll(this.findText, this.replaceText);
                    updated = updated || !endPage.equals(document.getEndPage());
                } else {
                    endPage = document.getEndPage();
                    boolean bl = updated ? true : (updated = false);
                }
                if (joined || !updated) continue;
                successful = new UpdateDocumentEdit(document.getDocumentID(), title, docAbstract, type, document.getCitationsCount(), doi, sourceIdentifier, volume, issue, beginPage, endPage).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

