/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinAuthorEdit;
import scimat.gui.commands.edit.update.UpdateAuthorEdit;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceAuthorsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInAuthorName;
    private boolean findInFullAuthorName;

    public GlobalReplaceAuthorsEdit(String findText, String replaceText, boolean findInAuthorName, boolean findInFullAuthorName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInAuthorName = findInAuthorName;
        this.findInFullAuthorName = findInFullAuthorName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
        try {
            ArrayList<Author> authors = authorDAO.getAuthors();
            for (int i = 0; i < authors.size(); ++i) {
                String fullAuthorName;
                String authorName;
                Author author = authors.get(i);
                if (this.findInAuthorName) {
                    authorName = author.getAuthorName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !authorName.equals(author.getAuthorName());
                } else {
                    authorName = author.getAuthorName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInFullAuthorName) {
                    fullAuthorName = author.getFullAuthorName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !fullAuthorName.equals(author.getFullAuthorName());
                } else {
                    fullAuthorName = author.getFullAuthorName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && authorDAO.checkAuthor(authorName, fullAuthorName)) {
                    ArrayList<Author> tmpArray = new ArrayList<Author>();
                    tmpArray.add(author);
                    successful = new JoinAuthorEdit(tmpArray, authorDAO.getAuthor(authorName, fullAuthorName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateAuthorEdit(author.getAuthorID(), authorName, fullAuthorName).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

