/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinAuthorReferenceEdit;
import scimat.gui.commands.edit.update.UpdateAuthorReferenceEdit;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceAuthorReferencesEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInAuthorName;

    public GlobalReplaceAuthorReferencesEdit(String findText, String replaceText, boolean findInAuthorName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInAuthorName = findInAuthorName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
        try {
            ArrayList<AuthorReference> authorReferences = authorReferenceDAO.getAuthorReferences();
            for (int i = 0; i < authorReferences.size(); ++i) {
                String authorName;
                AuthorReference authorReference = authorReferences.get(i);
                if (this.findInAuthorName) {
                    authorName = authorReference.getAuthorName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !authorName.equals(authorReference.getAuthorName());
                } else {
                    authorName = authorReference.getAuthorName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && authorReferenceDAO.checkAuthorReference(authorName)) {
                    ArrayList<AuthorReference> tmpArray = new ArrayList<AuthorReference>();
                    tmpArray.add(authorReference);
                    successful = new JoinAuthorReferenceEdit(tmpArray, authorReferenceDAO.getAuthorReference(authorName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateAuthorReferenceEdit(authorReference.getAuthorReferenceID(), authorName).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

