/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinAuthorReferenceGroupEdit;
import scimat.gui.commands.edit.update.UpdateAuthorReferenceGroupEdit;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceAuthorReferenceGroupsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInGroupName;

    public GlobalReplaceAuthorReferenceGroupsEdit(String findText, String replaceText, boolean findInGroupName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInGroupName = findInGroupName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
        try {
            ArrayList<AuthorReferenceGroup> authorReferenceGroups = authorReferenceGroupDAO.getAuthorReferenceGroups();
            for (int i = 0; i < authorReferenceGroups.size(); ++i) {
                String groupName;
                AuthorReferenceGroup authorReferenceGroup = authorReferenceGroups.get(i);
                if (this.findInGroupName) {
                    groupName = authorReferenceGroup.getGroupName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !groupName.equals(authorReferenceGroup.getGroupName());
                } else {
                    groupName = authorReferenceGroup.getGroupName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && authorReferenceGroupDAO.checkAuthorReferenceGroup(groupName)) {
                    ArrayList<AuthorReferenceGroup> tmpArray = new ArrayList<AuthorReferenceGroup>();
                    tmpArray.add(authorReferenceGroup);
                    successful = new JoinAuthorReferenceGroupEdit(tmpArray, authorReferenceGroupDAO.getAuthorReferenceGroup(groupName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateAuthorReferenceGroupEdit(authorReferenceGroup.getAuthorReferenceGroupID(), groupName, authorReferenceGroup.isStopGroup()).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

