/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinAuthorGroupEdit;
import scimat.gui.commands.edit.update.UpdateAuthorGroupEdit;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceAuthorGroupsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInGroupName;

    public GlobalReplaceAuthorGroupsEdit(String findText, String replaceText, boolean findInGroupName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInGroupName = findInGroupName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
        try {
            ArrayList<AuthorGroup> authorGroups = authorGroupDAO.getAuthorGroups();
            for (int i = 0; i < authorGroups.size(); ++i) {
                String groupName;
                AuthorGroup authorGroup = authorGroups.get(i);
                if (this.findInGroupName) {
                    groupName = authorGroup.getGroupName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !groupName.equals(authorGroup.getGroupName());
                } else {
                    groupName = authorGroup.getGroupName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && authorGroupDAO.checkAuthorGroup(groupName)) {
                    ArrayList<AuthorGroup> tmpArray = new ArrayList<AuthorGroup>();
                    tmpArray.add(authorGroup);
                    successful = new JoinAuthorGroupEdit(tmpArray, authorGroupDAO.getAuthorGroup(groupName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateAuthorGroupEdit(authorGroup.getAuthorGroupID(), groupName, authorGroup.isStopGroup()).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

