/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinAffiliationEdit;
import scimat.gui.commands.edit.update.UpdateAffiliationEdit;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceAffiliationsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInFullAffiliation;

    public GlobalReplaceAffiliationsEdit(String findText, String replaceText, boolean findInFullAffiliation) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInFullAffiliation = findInFullAffiliation;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
        try {
            ArrayList<Affiliation> affiliations = affiliationDAO.getAffiliations();
            for (int i = 0; i < affiliations.size(); ++i) {
                String fullAffiliation;
                Affiliation affiliation = affiliations.get(i);
                if (this.findInFullAffiliation) {
                    fullAffiliation = affiliation.getFullAffiliation().replaceAll(this.findText, this.replaceText);
                    updated = updated || !fullAffiliation.equals(affiliation.getFullAffiliation());
                } else {
                    fullAffiliation = affiliation.getFullAffiliation();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && affiliationDAO.checkAffiliation(fullAffiliation)) {
                    ArrayList<Affiliation> tmpArray = new ArrayList<Affiliation>();
                    tmpArray.add(affiliation);
                    successful = new JoinAffiliationEdit(tmpArray, affiliationDAO.getAffiliation(fullAffiliation)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateAffiliationEdit(affiliation.getAffiliationID(), fullAffiliation).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

