/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteWordsFromDocumentEdit
extends KnowledgeBaseEdit {
    private Document document;
    private ArrayList<DocumentWord> documentWords;

    public DeleteWordsFromDocumentEdit(Document document, ArrayList<DocumentWord> documentWords) {
        this.document = document;
        this.documentWords = documentWords;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            for (int i = 0; i < this.documentWords.size(); ++i) {
                documentWordDAO.removeDocumentWord(this.document.getDocumentID(), this.documentWords.get(i).getWord().getWordID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            for (int i = 0; i < this.documentWords.size(); ++i) {
                DocumentWord documentWord = this.documentWords.get(i);
                documentWordDAO.addDocumentWord(this.document.getDocumentID(), documentWord.getWord().getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            for (int i = 0; i < this.documentWords.size(); ++i) {
                documentWordDAO.removeDocumentWord(this.document.getDocumentID(), this.documentWords.get(i).getWord().getWordID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

