/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteWordGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<WordGroup> wordGroupsToDelete;
    private ArrayList<ArrayList<Word>> words = new ArrayList();

    public DeleteWordGroupEdit(ArrayList<WordGroup> wordGroupsToDelete) {
        this.wordGroupsToDelete = wordGroupsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            for (int i = 0; i < this.wordGroupsToDelete.size() && successful; ++i) {
                WordGroup wordGroup = this.wordGroupsToDelete.get(i);
                this.words.add(wordGroupDAO.getWords(wordGroup.getWordGroupID()));
                successful = wordGroupDAO.removeWordGroup(wordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            for (int i = 0; i < this.wordGroupsToDelete.size() && successful; ++i) {
                WordGroup wordGroup = this.wordGroupsToDelete.get(i);
                successful = wordGroupDAO.addWordGroup(wordGroup, true);
                for (int j = 0; j < this.words.get(i).size() && successful; ++j) {
                    Word word = this.words.get(i).get(j);
                    successful = wordDAO.setWordGroup(word.getWordID(), wordGroup.getWordGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            for (int i = 0; i < this.wordGroupsToDelete.size() && successful; ++i) {
                WordGroup wordGroup = this.wordGroupsToDelete.get(i);
                successful = wordGroupDAO.removeWordGroup(wordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

