/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteWordEdit
extends KnowledgeBaseEdit {
    private ArrayList<Word> wordsToDelete;
    private ArrayList<ArrayList<DocumentWord>> documentWords = new ArrayList();
    private ArrayList<WordGroup> wordGroups = new ArrayList();

    public DeleteWordEdit(ArrayList<Word> wordsToDelete) {
        this.wordsToDelete = wordsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            for (int i = 0; i < this.wordsToDelete.size() && successful; ++i) {
                Word word = this.wordsToDelete.get(i);
                this.documentWords.add(wordDAO.getDocumentWords(word.getWordID()));
                this.wordGroups.add(wordDAO.getWordGroup(word.getWordID()));
                successful = wordDAO.removeWord(word.getWordID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            for (int i = 0; i < this.wordsToDelete.size() && successful; ++i) {
                Word word = this.wordsToDelete.get(i);
                successful = wordDAO.addWord(word, true);
                for (int j = 0; j < this.documentWords.get(i).size() && successful; ++j) {
                    DocumentWord documentWord = this.documentWords.get(i).get(j);
                    successful = documentWordDAO.addDocumentWord(documentWord.getDocument().getDocumentID(), word.getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
                WordGroup wordGroup = this.wordGroups.get(i);
                if (wordGroup == null || !successful) continue;
                successful = wordDAO.setWordGroup(word.getWordID(), wordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            for (int i = 0; i < this.wordsToDelete.size() && successful; ++i) {
                Word word = this.wordsToDelete.get(i);
                successful = wordDAO.removeWord(word.getWordID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

