/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceGroupDAO;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteReferenceSourceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceSourceGroup> referenceSourceGroupsToDelete;
    private ArrayList<ArrayList<ReferenceSource>> referenceSources = new ArrayList();

    public DeleteReferenceSourceGroupEdit(ArrayList<ReferenceSourceGroup> referenceSourceGroupsToDelete) {
        this.referenceSourceGroupsToDelete = referenceSourceGroupsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            for (int i = 0; i < this.referenceSourceGroupsToDelete.size() && successful; ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroupsToDelete.get(i);
                this.referenceSources.add(referenceSourceGroupDAO.getReferenceSources(referenceSourceGroup.getReferenceSourceGroupID()));
                successful = referenceSourceGroupDAO.removeReferenceSourceGroup(referenceSourceGroup.getReferenceSourceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            for (int i = 0; i < this.referenceSourceGroupsToDelete.size() && successful; ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroupsToDelete.get(i);
                successful = referenceSourceGroupDAO.addReferenceSourceGroup(referenceSourceGroup, true);
                for (int j = 0; j < this.referenceSources.get(i).size() && successful; ++j) {
                    ReferenceSource referenceSource = this.referenceSources.get(i).get(j);
                    successful = referenceSourceDAO.setReferenceSourceGroup(referenceSource.getReferenceSourceID(), referenceSourceGroup.getReferenceSourceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            for (int i = 0; i < this.referenceSourceGroupsToDelete.size() && successful; ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroupsToDelete.get(i);
                successful = referenceSourceGroupDAO.removeReferenceSourceGroup(referenceSourceGroup.getReferenceSourceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

