/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteReferenceSourceEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceSource> referenceSourcesToDelete;
    private ArrayList<ArrayList<Reference>> references = new ArrayList();
    private ArrayList<ReferenceSourceGroup> referenceSourceGroups = new ArrayList();

    public DeleteReferenceSourceEdit(ArrayList<ReferenceSource> referenceSourcesToDelete) {
        this.referenceSourcesToDelete = referenceSourcesToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            for (int i = 0; i < this.referenceSourcesToDelete.size() && successful; ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToDelete.get(i);
                this.references.add(referenceSourceDAO.getReferences(referenceSource.getReferenceSourceID()));
                this.referenceSourceGroups.add(referenceSourceDAO.getReferenceSourceGroup(referenceSource.getReferenceSourceID()));
                successful = referenceSourceDAO.removeReferenceSource(referenceSource.getReferenceSourceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            for (int i = 0; i < this.referenceSourcesToDelete.size() && successful; ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToDelete.get(i);
                successful = referenceSourceDAO.addReferenceSource(referenceSource, true);
                for (int j = 0; j < this.references.get(i).size() && successful; ++j) {
                    successful = referenceDAO.setReferenceSource(referenceSource.getReferenceSourceID(), this.references.get(i).get(j).getReferenceID(), true);
                }
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroups.get(i);
                if (referenceSourceGroup == null || !successful) continue;
                successful = referenceSourceDAO.setReferenceSourceGroup(referenceSource.getReferenceSourceID(), referenceSourceGroup.getReferenceSourceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            for (int i = 0; i < this.referenceSourcesToDelete.size() && successful; ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToDelete.get(i);
                successful = referenceSourceDAO.removeReferenceSource(referenceSource.getReferenceSourceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

