/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceGroup> referenceGroupsToDelete;
    private ArrayList<ArrayList<Reference>> references = new ArrayList();

    public DeleteReferenceGroupEdit(ArrayList<ReferenceGroup> referenceGroupsToDelete) {
        this.referenceGroupsToDelete = referenceGroupsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            for (int i = 0; i < this.referenceGroupsToDelete.size() && successful; ++i) {
                ReferenceGroup referenceGroup = this.referenceGroupsToDelete.get(i);
                this.references.add(referenceGroupDAO.getReferences(referenceGroup.getReferenceGroupID()));
                successful = referenceGroupDAO.removeReferenceGroup(referenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            for (int i = 0; i < this.referenceGroupsToDelete.size() && successful; ++i) {
                ReferenceGroup referenceGroup = this.referenceGroupsToDelete.get(i);
                successful = referenceGroupDAO.addReferenceGroup(referenceGroup, true);
                for (int j = 0; j < this.references.get(i).size() && successful; ++j) {
                    Reference reference = this.references.get(i).get(j);
                    successful = referenceDAO.setReferenceGroup(reference.getReferenceID(), referenceGroup.getReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            for (int i = 0; i < this.referenceGroupsToDelete.size() && successful; ++i) {
                ReferenceGroup referenceGroup = this.referenceGroupsToDelete.get(i);
                successful = referenceGroupDAO.removeReferenceGroup(referenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

