/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteReferenceEdit
extends KnowledgeBaseEdit {
    private ArrayList<Reference> referencesToDelete;
    private ArrayList<ArrayList<Document>> documents = new ArrayList();
    private ArrayList<ArrayList<AuthorReferenceReference>> authorReferenceReferences = new ArrayList();
    private ArrayList<ReferenceGroup> referenceGroups = new ArrayList();
    private ArrayList<ReferenceSource> referenceSources = new ArrayList();

    public DeleteReferenceEdit(ArrayList<Reference> referencesToDelete) {
        this.referencesToDelete = referencesToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            for (int i = 0; i < this.referencesToDelete.size() && successful; ++i) {
                Reference reference = this.referencesToDelete.get(i);
                this.documents.add(referenceDAO.getDocuments(reference.getReferenceID()));
                this.authorReferenceReferences.add(referenceDAO.getAuthorReferenceReferences(reference.getReferenceID()));
                this.referenceGroups.add(referenceDAO.getReferenceGroup(reference.getReferenceID()));
                this.referenceSources.add(referenceDAO.getReferenceSource(reference.getReferenceID()));
                successful = referenceDAO.removeReference(reference.getReferenceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            for (int i = 0; i < this.referencesToDelete.size() && successful; ++i) {
                ReferenceSource referenceSource;
                int j;
                Reference reference = this.referencesToDelete.get(i);
                successful = referenceDAO.addReference(reference, true);
                for (j = 0; j < this.authorReferenceReferences.get(i).size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = this.authorReferenceReferences.get(i).get(j);
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(reference.getReferenceID(), authorReferenceReference.getAuthorReference().getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
                for (j = 0; j < this.documents.get(i).size() && successful; ++j) {
                    successful = documentReferenceDAO.addDocumentReference(this.documents.get(i).get(j).getDocumentID(), reference.getReferenceID(), true);
                }
                ReferenceGroup referenceGroup = this.referenceGroups.get(i);
                if (referenceGroup != null && successful) {
                    successful = referenceDAO.setReferenceGroup(reference.getReferenceID(), referenceGroup.getReferenceGroupID(), true);
                }
                if ((referenceSource = this.referenceSources.get(i)) == null || !successful) continue;
                successful = referenceDAO.setReferenceSource(reference.getReferenceID(), referenceSource.getReferenceSourceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            for (int i = 0; i < this.referencesToDelete.size() && successful; ++i) {
                Reference reference = this.referencesToDelete.get(i);
                successful = referenceDAO.removeReference(reference.getReferenceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

