/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDatePeriodDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletePublishDateEdit
extends KnowledgeBaseEdit {
    private ArrayList<PublishDate> publishDatesToDelete;
    private ArrayList<ArrayList<Period>> periods = new ArrayList();
    private ArrayList<ArrayList<Document>> documents = new ArrayList();

    public DeletePublishDateEdit(ArrayList<PublishDate> publishDatesToDelete) {
        this.publishDatesToDelete = publishDatesToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            for (int i = 0; i < this.publishDatesToDelete.size() && successful; ++i) {
                PublishDate publishDate = this.publishDatesToDelete.get(i);
                this.documents.add(publishDateDAO.getDocuments(publishDate.getPublishDateID()));
                this.periods.add(publishDateDAO.getPeriods(publishDate.getPublishDateID()));
                successful = publishDateDAO.removePublishDate(publishDate.getPublishDateID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            for (int i = 0; i < this.publishDatesToDelete.size() && successful; ++i) {
                int j;
                PublishDate publishDate = this.publishDatesToDelete.get(i);
                successful = publishDateDAO.addPublishDate(publishDate, true);
                for (j = 0; j < this.documents.get(i).size() && successful; ++j) {
                    Document document = this.documents.get(i).get(j);
                    successful = documentDAO.setPublishDate(document.getDocumentID(), publishDate.getPublishDateID(), true);
                }
                for (j = 0; j < this.periods.get(i).size() && successful; ++j) {
                    successful = publishDatePeriodDAO.addPublishDatePeriod(this.periods.get(i).get(j).getPeriodID(), publishDate.getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            for (int i = 0; i < this.publishDatesToDelete.size() && successful; ++i) {
                PublishDate publishDate = this.publishDatesToDelete.get(i);
                successful = publishDateDAO.removePublishDate(publishDate.getPublishDateID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

