/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.PeriodDAO;
import scimat.model.knowledgebase.dao.PublishDatePeriodDAO;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletePeriodEdit
extends KnowledgeBaseEdit {
    private ArrayList<Period> periodsToDelete;
    private ArrayList<ArrayList<PublishDate>> publishDates = new ArrayList();

    public DeletePeriodEdit(ArrayList<Period> periodsToDelete) {
        this.periodsToDelete = periodsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            for (int i = 0; i < this.periodsToDelete.size() && successful; ++i) {
                Period period = this.periodsToDelete.get(i);
                this.publishDates.add(periodDAO.getPublishDates(period.getPeriodID()));
                successful = periodDAO.removePeriod(period.getPeriodID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            for (int i = 0; i < this.periodsToDelete.size() && successful; ++i) {
                Period period = this.periodsToDelete.get(i);
                successful = periodDAO.addPeriod(period, true);
                for (int j = 0; j < this.publishDates.get(i).size() && successful; ++j) {
                    successful = publishDatePeriodDAO.addPublishDatePeriod(period.getPeriodID(), this.publishDates.get(i).get(j).getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            for (int i = 0; i < this.periodsToDelete.size() && successful; ++i) {
                Period period = this.periodsToDelete.get(i);
                successful = periodDAO.removePeriod(period.getPeriodID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

