/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.JournalSubjectCategoryPublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteJournalEdit
extends KnowledgeBaseEdit {
    private ArrayList<Journal> journalsToDelete;
    private ArrayList<ArrayList<Document>> documents = new ArrayList();
    private ArrayList<ArrayList<JournalSubjectCategoryPublishDate>> journalSubjectCategoryPublishDates = new ArrayList();

    public DeleteJournalEdit(ArrayList<Journal> journalsToDelete) {
        this.journalsToDelete = journalsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            for (int i = 0; i < this.journalsToDelete.size() && successful; ++i) {
                Journal journal = this.journalsToDelete.get(i);
                this.documents.add(journalDAO.getDocuments(journal.getJournalID()));
                this.journalSubjectCategoryPublishDates.add(journalDAO.getJournalSubjectCategoryPublishDates(journal.getJournalID()));
                successful = journalDAO.removeJournal(journal.getJournalID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            for (int i = 0; i < this.journalsToDelete.size() && successful; ++i) {
                int j;
                Journal journal = this.journalsToDelete.get(i);
                successful = journalDAO.addJournal(journal, true);
                for (j = 0; j < this.journalSubjectCategoryPublishDates.get(i).size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = this.journalSubjectCategoryPublishDates.get(i).get(j);
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
                for (j = 0; j < this.documents.get(i).size() && successful; ++j) {
                    successful = documentDAO.setJournal(this.documents.get(i).get(j).getDocumentID(), journal.getJournalID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            for (int i = 0; i < this.journalsToDelete.size() && successful; ++i) {
                Journal journal = this.journalsToDelete.get(i);
                successful = journalDAO.removeJournal(journal.getJournalID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

