/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDocumentEdit
extends KnowledgeBaseEdit {
    private ArrayList<Document> documentsToDelete;
    private ArrayList<ArrayList<Affiliation>> affiliations = new ArrayList();
    private ArrayList<ArrayList<DocumentAuthor>> documentAuthors = new ArrayList();
    private ArrayList<ArrayList<Reference>> references = new ArrayList();
    private ArrayList<ArrayList<DocumentWord>> documentWords = new ArrayList();
    private ArrayList<PublishDate> publishDates = new ArrayList();
    private ArrayList<Journal> journals = new ArrayList();

    public DeleteDocumentEdit(ArrayList<Document> documentsToDelete) {
        this.documentsToDelete = documentsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            for (int i = 0; i < this.documentsToDelete.size() && successful; ++i) {
                Document document = this.documentsToDelete.get(i);
                this.affiliations.add(documentDAO.getAffiliations(document.getDocumentID()));
                this.documentAuthors.add(documentDAO.getDocumentAuthors(document.getDocumentID()));
                this.documentWords.add(documentDAO.getDocumentWords(document.getDocumentID()));
                this.publishDates.add(documentDAO.getPublishDate(document.getDocumentID()));
                this.journals.add(documentDAO.getJournal(document.getDocumentID()));
                this.references.add(documentDAO.getReferences(document.getDocumentID()));
                successful = documentDAO.removeDocument(document.getDocumentID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            for (int i = 0; i < this.documentsToDelete.size() && successful; ++i) {
                Journal journal;
                int j;
                Document document = this.documentsToDelete.get(i);
                successful = documentDAO.addDocument(document, true);
                for (j = 0; j < this.documentAuthors.get(i).size() && successful; ++j) {
                    DocumentAuthor documentAuthor = this.documentAuthors.get(i).get(j);
                    successful = documentAuthorDAO.addDocumentAuthor(document.getDocumentID(), documentAuthor.getAuthor().getAuthorID(), documentAuthor.getPosition(), true);
                }
                for (j = 0; j < this.affiliations.get(i).size() && successful; ++j) {
                    successful = documentAffiliationDAO.addDocumentAffiliation(document.getDocumentID(), this.affiliations.get(i).get(j).getAffiliationID(), true);
                }
                for (j = 0; j < this.documentWords.get(i).size() && successful; ++j) {
                    DocumentWord documentWord = this.documentWords.get(i).get(j);
                    successful = documentWordDAO.addDocumentWord(document.getDocumentID(), documentWord.getWord().getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
                for (j = 0; j < this.references.get(i).size() && successful; ++j) {
                    successful = documentReferenceDAO.addDocumentReference(document.getDocumentID(), this.references.get(i).get(j).getReferenceID(), true);
                }
                PublishDate publishDate = this.publishDates.get(i);
                if (publishDate != null && successful) {
                    successful = documentDAO.setPublishDate(document.getDocumentID(), publishDate.getPublishDateID(), true);
                }
                if ((journal = this.journals.get(i)) == null || !successful) continue;
                successful = documentDAO.setJournal(document.getDocumentID(), journal.getJournalID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            for (int i = 0; i < this.documentsToDelete.size() && successful; ++i) {
                Document document = this.documentsToDelete.get(i);
                successful = documentDAO.removeDocument(document.getDocumentID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

