/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAuthorReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorReferenceGroup> authorReferenceGroupsToDelete;
    private ArrayList<ArrayList<AuthorReference>> authorReferences = new ArrayList();

    public DeleteAuthorReferenceGroupEdit(ArrayList<AuthorReferenceGroup> authorReferenceGroupsToDelete) {
        this.authorReferenceGroupsToDelete = authorReferenceGroupsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            for (int i = 0; i < this.authorReferenceGroupsToDelete.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.authorReferenceGroupsToDelete.get(i);
                this.authorReferences.add(authorReferenceGroupDAO.getAuthorReferences(authorReferenceGroup.getAuthorReferenceGroupID()));
                successful = authorReferenceGroupDAO.removeAuthorReferenceGroup(authorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            for (int i = 0; i < this.authorReferenceGroupsToDelete.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.authorReferenceGroupsToDelete.get(i);
                successful = authorReferenceGroupDAO.addAuthorReferenceGroup(authorReferenceGroup, true);
                for (int j = 0; j < this.authorReferences.get(i).size() && successful; ++j) {
                    AuthorReference authorReference = this.authorReferences.get(i).get(j);
                    successful = authorReferenceDAO.setAuthorReferenceGroup(authorReference.getAuthorReferenceID(), authorReferenceGroup.getAuthorReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            for (int i = 0; i < this.authorReferenceGroupsToDelete.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.authorReferenceGroupsToDelete.get(i);
                successful = authorReferenceGroupDAO.removeAuthorReferenceGroup(authorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

