/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAuthorReferenceEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorReference> authorReferencesToDelete;
    private ArrayList<ArrayList<AuthorReferenceReference>> authorReferenceReferences = new ArrayList();
    private ArrayList<Author> authors = new ArrayList();
    private ArrayList<AuthorReferenceGroup> authorReferenceGroups = new ArrayList();

    public DeleteAuthorReferenceEdit(ArrayList<AuthorReference> authorReferencesToDelete) {
        this.authorReferencesToDelete = authorReferencesToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            for (int i = 0; i < this.authorReferencesToDelete.size() && successful; ++i) {
                AuthorReference authorReference = this.authorReferencesToDelete.get(i);
                this.authorReferenceReferences.add(authorReferenceDAO.getReferences(authorReference.getAuthorReferenceID()));
                this.authors.add(authorReferenceDAO.getAuthor(authorReference.getAuthorReferenceID()));
                this.authorReferenceGroups.add(authorReferenceDAO.getAuthorReferenceGroup(authorReference.getAuthorReferenceID()));
                successful = authorReferenceDAO.removeAuthorReference(authorReference.getAuthorReferenceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            for (int i = 0; i < this.authorReferencesToDelete.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup;
                AuthorReference authorReference = this.authorReferencesToDelete.get(i);
                successful = authorReferenceDAO.addAuthorReference(authorReference, true);
                for (int j = 0; j < this.authorReferenceReferences.get(i).size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = this.authorReferenceReferences.get(i).get(j);
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(authorReferenceReference.getAuthorReference().getAuthorReferenceID(), authorReference.getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
                Author author = authorReferenceDAO.getAuthor(authorReference.getAuthorReferenceID());
                if (author != null && successful) {
                    successful = authorReferenceDAO.setAuthor(authorReference.getAuthorReferenceID(), author.getAuthorID(), true);
                }
                if ((authorReferenceGroup = authorReferenceDAO.getAuthorReferenceGroup(authorReference.getAuthorReferenceID())) == null || !successful) continue;
                successful = authorReferenceDAO.setAuthorReferenceGroup(authorReference.getAuthorReferenceID(), authorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            for (int i = 0; i < this.authorReferencesToDelete.size() && successful; ++i) {
                AuthorReference authorReference = this.authorReferencesToDelete.get(i);
                successful = authorReferenceDAO.removeAuthorReference(authorReference.getAuthorReferenceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

