/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAuthorGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorGroup> authorGroupsToDelete;
    private ArrayList<ArrayList<Author>> authors = new ArrayList();

    public DeleteAuthorGroupEdit(ArrayList<AuthorGroup> authorGroupsToDelete) {
        this.authorGroupsToDelete = authorGroupsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            for (int i = 0; i < this.authorGroupsToDelete.size() && successful; ++i) {
                AuthorGroup authorGroup = this.authorGroupsToDelete.get(i);
                this.authors.add(authorGroupDAO.getAuthors(authorGroup.getAuthorGroupID()));
                successful = authorGroupDAO.removeAuthorGroup(authorGroup.getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            for (int i = 0; i < this.authorGroupsToDelete.size() && successful; ++i) {
                AuthorGroup authorGroup = this.authorGroupsToDelete.get(i);
                successful = authorGroupDAO.addAuthorGroup(authorGroup, true);
                for (int j = 0; j < this.authors.get(i).size() && successful; ++j) {
                    Author author = this.authors.get(i).get(j);
                    successful = authorDAO.setAuthorGroup(author.getAuthorID(), authorGroup.getAuthorGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            for (int i = 0; i < this.authorGroupsToDelete.size() && successful; ++i) {
                AuthorGroup authorGroup = this.authorGroupsToDelete.get(i);
                successful = authorGroupDAO.removeAuthorGroup(authorGroup.getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

