/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorAffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAuthorEdit
extends KnowledgeBaseEdit {
    private ArrayList<Author> authorsToDelete;
    private ArrayList<ArrayList<Affiliation>> affiliations = new ArrayList();
    private ArrayList<ArrayList<DocumentAuthor>> documentAuthors = new ArrayList();
    private ArrayList<AuthorGroup> authorGroups = new ArrayList();
    private ArrayList<AuthorReference> authorReferences = new ArrayList();

    public DeleteAuthorEdit(ArrayList<Author> authorsToDelete) {
        this.authorsToDelete = authorsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            for (int i = 0; i < this.authorsToDelete.size() && successful; ++i) {
                Author author = this.authorsToDelete.get(i);
                this.affiliations.add(authorDAO.getAffiliations(author.getAuthorID()));
                this.documentAuthors.add(authorDAO.getDocumentAuthors(author.getAuthorID()));
                this.authorGroups.add(authorDAO.getAuthorGroup(author.getAuthorID()));
                this.authorReferences.add(authorDAO.getAuthorReference(author.getAuthorID()));
                successful = authorDAO.removeAuthor(author.getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            for (int i = 0; i < this.authorsToDelete.size() && successful; ++i) {
                AuthorReference authorReference;
                int j;
                Author author = this.authorsToDelete.get(i);
                successful = authorDAO.addAuthor(author, true);
                for (j = 0; j < this.documentAuthors.get(i).size() && successful; ++j) {
                    DocumentAuthor documentAuthor = this.documentAuthors.get(i).get(j);
                    successful = documentAuthorDAO.addDocumentAuthor(documentAuthor.getDocument().getDocumentID(), author.getAuthorID(), documentAuthor.getPosition(), true);
                }
                for (j = 0; j < this.affiliations.get(i).size() && successful; ++j) {
                    successful = authorAffiliationDAO.addAuthorAffiliation(author.getAuthorID(), this.affiliations.get(i).get(j).getAffiliationID(), true);
                }
                AuthorGroup authorGroup = this.authorGroups.get(i);
                if (authorGroup != null && successful) {
                    successful = authorDAO.setAuthorGroup(author.getAuthorID(), authorGroup.getAuthorGroupID(), true);
                }
                if ((authorReference = this.authorReferences.get(i)) == null || !successful) continue;
                successful = authorReferenceDAO.setAuthor(authorReference.getAuthorReferenceID(), author.getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            for (int i = 0; i < this.authorsToDelete.size() && successful; ++i) {
                Author author = this.authorsToDelete.get(i);
                successful = authorDAO.removeAuthor(author.getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

