/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.delete;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAffiliationEdit
extends KnowledgeBaseEdit {
    private ArrayList<Affiliation> affiliationsToDelete;
    private ArrayList<ArrayList<Author>> authors = new ArrayList();
    private ArrayList<ArrayList<Document>> documents = new ArrayList();

    public DeleteAffiliationEdit(ArrayList<Affiliation> affiliationsToDelete) {
        this.affiliationsToDelete = affiliationsToDelete;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            for (int i = 0; i < this.affiliationsToDelete.size() && successful; ++i) {
                Affiliation affiliation = this.affiliationsToDelete.get(i);
                this.authors.add(affiliationDAO.getAuthors(affiliation.getAffiliationID()));
                this.documents.add(affiliationDAO.getDocuments(affiliation.getAffiliationID()));
                successful = affiliationDAO.removeAffiliation(affiliation.getAffiliationID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            for (int i = 0; i < this.affiliationsToDelete.size() && successful; ++i) {
                int j;
                Affiliation affiliation = this.affiliationsToDelete.get(i);
                successful = affiliationDAO.addAffiliation(affiliation, true);
                for (j = 0; j < this.documents.get(i).size() && successful; ++j) {
                    successful = documentAffiliationDAO.addDocumentAffiliation(this.documents.get(i).get(j).getDocumentID(), affiliation.getAffiliationID(), true);
                }
                for (j = 0; j < this.authors.get(i).size() && successful; ++j) {
                    successful = authorAffiliationDAO.addAuthorAffiliation(this.authors.get(i).get(j).getAuthorID(), affiliation.getAffiliationID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            for (int i = 0; i < this.affiliationsToDelete.size() && successful; ++i) {
                Affiliation affiliation = this.affiliationsToDelete.get(i);
                successful = affiliationDAO.removeAffiliation(affiliation.getAffiliationID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

