/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddWordsToWordGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<Word> wordsToAdd;
    private ArrayList<WordGroup> oldWordGroupOfWords;
    private WordGroup targetWordGroup;

    public AddWordsToWordGroupEdit(ArrayList<Word> wordsToAdd, WordGroup targetWordGroup) {
        this.wordsToAdd = wordsToAdd;
        this.targetWordGroup = targetWordGroup;
        this.oldWordGroupOfWords = new ArrayList();
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            for (int i = 0; i < this.wordsToAdd.size(); ++i) {
                Word word = this.wordsToAdd.get(i);
                this.oldWordGroupOfWords.add(CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWordGroup(word.getWordID()));
                successful = CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordGroup(word.getWordID(), this.targetWordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.wordsToAdd.size(); ++i) {
                WordGroup wordGroup = this.oldWordGroupOfWords.get(i);
                successful = wordGroup != null ? CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordGroup(this.wordsToAdd.get(i).getWordID(), wordGroup.getWordGroupID(), true) : CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordGroup(this.wordsToAdd.get(i).getWordID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.wordsToAdd.size(); ++i) {
                successful = CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordGroup(this.wordsToAdd.get(i).getWordID(), this.targetWordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

