/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddReferencesToReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<Reference> referencesToAdd;
    private ArrayList<ReferenceGroup> oldReferenceGroupOfReferences;
    private ReferenceGroup targetReferenceGroup;

    public AddReferencesToReferenceGroupEdit(ArrayList<Reference> referencesToAdd, ReferenceGroup targetReferenceGroup) {
        this.referencesToAdd = referencesToAdd;
        this.targetReferenceGroup = targetReferenceGroup;
        this.oldReferenceGroupOfReferences = new ArrayList();
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            for (int i = 0; i < this.referencesToAdd.size(); ++i) {
                Reference reference = this.referencesToAdd.get(i);
                this.oldReferenceGroupOfReferences.add(CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReferenceGroup(reference.getReferenceID()));
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().setReferenceGroup(reference.getReferenceID(), this.targetReferenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.referencesToAdd.size(); ++i) {
                ReferenceGroup referenceGroup = this.oldReferenceGroupOfReferences.get(i);
                successful = referenceGroup != null ? CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().setReferenceGroup(this.referencesToAdd.get(i).getReferenceID(), referenceGroup.getReferenceGroupID(), true) : CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().setReferenceGroup(this.referencesToAdd.get(i).getReferenceID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.referencesToAdd.size(); ++i) {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().setReferenceGroup(this.referencesToAdd.get(i).getReferenceID(), this.targetReferenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

