/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddReferenceSourcesToReferenceSourceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceSource> referenceSourcesToAdd;
    private ArrayList<ReferenceSourceGroup> oldReferenceSourceGroupOfReferenceSources;
    private ReferenceSourceGroup targetReferenceSourceGroup;

    public AddReferenceSourcesToReferenceSourceGroupEdit(ArrayList<ReferenceSource> referenceSourcesToAdd, ReferenceSourceGroup targetReferenceSourceGroup) {
        this.referenceSourcesToAdd = referenceSourcesToAdd;
        this.targetReferenceSourceGroup = targetReferenceSourceGroup;
        this.oldReferenceSourceGroupOfReferenceSources = new ArrayList();
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            for (int i = 0; i < this.referenceSourcesToAdd.size(); ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToAdd.get(i);
                this.oldReferenceSourceGroupOfReferenceSources.add(CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSourceGroup(referenceSource.getReferenceSourceID()));
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setReferenceSourceGroup(referenceSource.getReferenceSourceID(), this.targetReferenceSourceGroup.getReferenceSourceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.referenceSourcesToAdd.size(); ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.oldReferenceSourceGroupOfReferenceSources.get(i);
                successful = referenceSourceGroup != null ? CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setReferenceSourceGroup(this.referenceSourcesToAdd.get(i).getReferenceSourceID(), referenceSourceGroup.getReferenceSourceGroupID(), true) : CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setReferenceSourceGroup(this.referenceSourcesToAdd.get(i).getReferenceSourceID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.referenceSourcesToAdd.size(); ++i) {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setReferenceSourceGroup(this.referenceSourcesToAdd.get(i).getReferenceSourceID(), this.targetReferenceSourceGroup.getReferenceSourceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

