/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AddReferenceSourceEdit
extends KnowledgeBaseEdit {
    private Integer referenceSourceID;
    private String source;
    private ArrayList<ReferenceSource> referenceSourcesAdded;

    public AddReferenceSourceEdit(String source) {
        this.source = source;
        this.referenceSourcesAdded = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.source == null) {
                successful = false;
                this.errorMessage = "The source can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().checkReferenceSource(this.source)) {
                successful = false;
                this.errorMessage = "A reference source yet exists with this source.";
            } else {
                this.referenceSourceID = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().addReferenceSource(this.source, true);
                if (this.referenceSourceID != null) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    this.referenceSourcesAdded.add(CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSource(this.referenceSourceID));
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().removeReferenceSource(this.referenceSourceID, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().addReferenceSource(this.referenceSourceID, this.source, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

