/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AddReferenceGroupEdit
extends KnowledgeBaseEdit {
    private Integer referenceGroupID;
    private String groupName;
    private boolean stopGroup;
    private ArrayList<ReferenceGroup> authorsAdded;

    public AddReferenceGroupEdit(String groupName, boolean stopGroup) {
        this.groupName = groupName;
        this.stopGroup = stopGroup;
        this.authorsAdded = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.groupName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().checkReferenceGroup(this.groupName)) {
                successful = false;
                this.errorMessage = "A reference group yet exists with this name.";
            } else {
                this.referenceGroupID = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().addReferenceGroup(this.groupName, this.stopGroup, true);
                if (this.referenceGroupID != null) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    this.authorsAdded.add(CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().getReferenceGroup(this.referenceGroupID));
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().removeReferenceGroup(this.referenceGroupID, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().addReferenceGroup(this.referenceGroupID, this.groupName, this.stopGroup, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

