/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AddPeriodEdit
extends KnowledgeBaseEdit {
    private Integer periodID;
    private String name;
    private int position;
    private ArrayList<Period> periodsAdded;

    public AddPeriodEdit(String name) {
        this.name = name;
        this.periodsAdded = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.name == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().checkPeriod(this.name)) {
                successful = false;
                this.errorMessage = "A period yet exists with this name.";
            } else {
                this.position = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getMaxPosition() + 1;
                this.periodID = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().addPeriod(this.name, this.position, true);
                if (this.periodID != null) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    this.periodsAdded.add(CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriod(this.periodID));
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().removePeriod(this.periodID, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().addPeriod(this.periodID, this.name, this.position, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

