/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AddJournalToDocumentEdit
extends KnowledgeBaseEdit {
    private Document document;
    private Journal journal;
    private Journal oldJournal;

    public AddJournalToDocumentEdit(Document document, Journal journal) {
        this.document = document;
        this.journal = journal;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            this.oldJournal = documentDAO.getJournal(this.document.getDocumentID());
            if (this.journal != null) {
                documentDAO.setJournal(this.document.getDocumentID(), this.journal.getJournalID(), true);
            } else {
                documentDAO.setJournal(this.document.getDocumentID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            if (this.oldJournal != null) {
                documentDAO.setJournal(this.document.getDocumentID(), this.oldJournal.getJournalID(), true);
            } else {
                documentDAO.setJournal(this.document.getDocumentID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            if (this.journal != null) {
                documentDAO.setJournal(this.document.getDocumentID(), this.journal.getJournalID(), true);
            } else {
                documentDAO.setJournal(this.document.getDocumentID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

