/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAuthorsToAuthorGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<Author> authorsToAdd;
    private ArrayList<AuthorGroup> oldAuthorGroupOfAuthors;
    private AuthorGroup targetAuthorGroup;

    public AddAuthorsToAuthorGroupEdit(ArrayList<Author> authorsToAdd, AuthorGroup targetAuthorGroup) {
        this.authorsToAdd = authorsToAdd;
        this.targetAuthorGroup = targetAuthorGroup;
        this.oldAuthorGroupOfAuthors = new ArrayList();
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            for (int i = 0; i < this.authorsToAdd.size(); ++i) {
                Author author = this.authorsToAdd.get(i);
                this.oldAuthorGroupOfAuthors.add(CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().getAuthorGroup(author.getAuthorID()));
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().setAuthorGroup(author.getAuthorID(), this.targetAuthorGroup.getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.authorsToAdd.size(); ++i) {
                AuthorGroup authorGroup = this.oldAuthorGroupOfAuthors.get(i);
                successful = authorGroup != null ? CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().setAuthorGroup(this.authorsToAdd.get(i).getAuthorID(), authorGroup.getAuthorGroupID(), true) : CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().setAuthorGroup(this.authorsToAdd.get(i).getAuthorID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.authorsToAdd.size(); ++i) {
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().setAuthorGroup(this.authorsToAdd.get(i).getAuthorID(), this.targetAuthorGroup.getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

