/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.add;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAuthorReferencesToAuthorReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorReference> authorReferencesToAdd;
    private ArrayList<AuthorReferenceGroup> oldAuthorReferenceGroupOfAuthorReferences;
    private AuthorReferenceGroup targetAuthorReferenceGroup;

    public AddAuthorReferencesToAuthorReferenceGroupEdit(ArrayList<AuthorReference> authorReferencesToAdd, AuthorReferenceGroup targetAuthorReferenceGroup) {
        this.authorReferencesToAdd = authorReferencesToAdd;
        this.targetAuthorReferenceGroup = targetAuthorReferenceGroup;
        this.oldAuthorReferenceGroupOfAuthorReferences = new ArrayList();
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            for (int i = 0; i < this.authorReferencesToAdd.size(); ++i) {
                AuthorReference authorReference = this.authorReferencesToAdd.get(i);
                this.oldAuthorReferenceGroupOfAuthorReferences.add(CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(authorReference.getAuthorReferenceID()));
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().setAuthorReferenceGroup(authorReference.getAuthorReferenceID(), this.targetAuthorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.authorReferencesToAdd.size(); ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.oldAuthorReferenceGroupOfAuthorReferences.get(i);
                successful = authorReferenceGroup != null ? CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().setAuthorReferenceGroup(this.authorReferencesToAdd.get(i).getAuthorReferenceID(), authorReferenceGroup.getAuthorReferenceGroupID(), true) : CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().setAuthorReferenceGroup(this.authorReferencesToAdd.get(i).getAuthorReferenceID(), null, true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = false;
        try {
            for (int i = 0; i < this.authorReferencesToAdd.size(); ++i) {
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().setAuthorReferenceGroup(this.authorReferencesToAdd.get(i).getAuthorReferenceID(), this.targetAuthorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

