/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import scimat.gui.commands.task.CloseProjectTask;
import scimat.gui.commands.task.ExportGroupTask;
import scimat.gui.commands.task.FindSimilarAuthorReferencesWithoutGroupByDistanceTask;
import scimat.gui.commands.task.FindSimilarAuthorsWithoutGroupByDistanceTask;
import scimat.gui.commands.task.FindSimilarReferenceSourcesWithoutGroupByDistanceTask;
import scimat.gui.commands.task.FindSimilarReferencesWithoutGroupByDistanceTask;
import scimat.gui.commands.task.FindSimilarWordsWithoutGroupByDistanceTask;
import scimat.gui.commands.task.FindSimilarWordsWithoutGroupByPluralsTask;
import scimat.gui.commands.task.ImportFileTask;
import scimat.gui.commands.task.ImportGroupTask;
import scimat.gui.commands.task.LoadAnalysisTask;
import scimat.gui.commands.task.LoadProjectTask;
import scimat.gui.commands.task.ShowManagerTask;
import scimat.gui.components.AboutDialog;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.KnowledgeBaseStateObserverMenuItem;
import scimat.gui.components.NewProjectMenuItem;
import scimat.gui.components.NewProjectToolBarButton;
import scimat.gui.components.OpenProjectMenuItem;
import scimat.gui.components.OpenProjectToolBarButton;
import scimat.gui.components.RedoMenuItem;
import scimat.gui.components.RedoToolBarButton;
import scimat.gui.components.UndoMenuItem;
import scimat.gui.components.UndoToolBarButton;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.analysisview.AnalysisViewManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.globalreplace.GlobalReplaceDialogManager;
import scimat.gui.components.joindialog.JoinEntitiesDialogManager;
import scimat.gui.components.manager.AffiliationManager;
import scimat.gui.components.manager.AuthorGroupManager;
import scimat.gui.components.manager.AuthorGroupManualSetManager;
import scimat.gui.components.manager.AuthorManager;
import scimat.gui.components.manager.AuthorReferenceGroupManager;
import scimat.gui.components.manager.AuthorReferenceGroupManualSetManager;
import scimat.gui.components.manager.AuthorReferenceManager;
import scimat.gui.components.manager.DocumentManager;
import scimat.gui.components.manager.JournalManager;
import scimat.gui.components.manager.PeriodManager;
import scimat.gui.components.manager.PublishDateManager;
import scimat.gui.components.manager.ReferenceGroupManager;
import scimat.gui.components.manager.ReferenceGroupManualSetManager;
import scimat.gui.components.manager.ReferenceManager;
import scimat.gui.components.manager.ReferenceSourceGroupManager;
import scimat.gui.components.manager.ReferenceSourceGroupManualSetManager;
import scimat.gui.components.manager.ReferenceSourceManager;
import scimat.gui.components.manager.SubjectCategoryManager;
import scimat.gui.components.manager.WordGroupManager;
import scimat.gui.components.manager.WordGroupManualSetManager;
import scimat.gui.components.manager.WordManager;
import scimat.gui.components.movetogroup.MoveToGroupDialogManager;
import scimat.gui.components.statistic.StatisticDialogManager;
import scimat.gui.components.wizard.WizardManager;
import scimat.gui.undostack.UndoStack;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class MainFrame
extends JFrame {
    private JMenuItem aboutMenuItem;
    private JMenu addFilesMenu;
    private KnowledgeBaseStateObserverMenuItem affiliationsManagerMenuItem;
    private JMenu analysisMenu;
    private KnowledgeBaseStateObserverMenuItem authorGroupManualSetMenuItem;
    private JMenu authorGroupMenu;
    private KnowledgeBaseStateObserverMenuItem authorGroupStatisticsMenuItem;
    private KnowledgeBaseStateObserverMenuItem authorReferenceGroupManualSetMenuItem;
    private JMenu authorReferenceGroupMenu;
    private KnowledgeBaseStateObserverMenuItem authorsGroupsManagerMenuItem;
    private KnowledgeBaseStateObserverMenuItem authorsManagerMenuItem;
    private JMenu authorsMenu;
    private KnowledgeBaseStateObserverMenuItem authorsReferenceManagerMenuItem;
    private KnowledgeBaseStateObserverMenuItem authorsReferencesGroupManagerMenuItem;
    private KnowledgeBaseStateObserverMenuItem closeProjectMenuItem;
    private KnowledgeBaseStateObserverMenuItem documentsManagerMenuItem;
    private JMenu documentsMenu;
    private JMenu editMenu;
    private JToolBar editToolBar;
    private JMenuItem exitMenuItem;
    private KnowledgeBaseStateObserverMenuItem exportGroupsMenuItem;
    private JMenu exportMenu;
    private JMenu fileMenu;
    private JToolBar fileToolBar;
    private KnowledgeBaseStateObserverMenuItem findSimilarAuthorReferencesByDistanceMenuItem;
    private KnowledgeBaseStateObserverMenuItem findSimilarAuthorsByDistanceMenuItem;
    private KnowledgeBaseStateObserverMenuItem findSimilarReferenceSourcesByDistanceMenuItem;
    private KnowledgeBaseStateObserverMenuItem findSimilarReferencesByDistanceMenuItem;
    private KnowledgeBaseStateObserverMenuItem findSimilarWordsByDistanceMenuItem;
    private KnowledgeBaseStateObserverMenuItem findSimilarWordsByPluralsMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceAffiliationMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceAuthorGroupMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceAuthorMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceAuthorReferenceGroupMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceAuthorReferenceMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceDocumentMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceJournalMenuItem;
    private JMenu globalReplaceMenu;
    private KnowledgeBaseStateObserverMenuItem globalReplacePeriodMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplacePublishDateMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceReferenceGroupMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceReferenceMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceReferenceSourceGroupMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceReferenceSourceMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceSubjectCategoryMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceWordGroupMenuItem;
    private KnowledgeBaseStateObserverMenuItem globalReplaceWordMenuItem;
    private JMenu groupSetMenu;
    private JMenu helpMenu;
    private KnowledgeBaseStateObserverMenuItem importFromCsvMenuItem;
    private KnowledgeBaseStateObserverMenuItem importFromISIWoSMenuItem;
    private KnowledgeBaseStateObserverMenuItem importFromRISMenuItem;
    private KnowledgeBaseStateObserverMenuItem importGroupsMenuItem;
    private JMenu importMenu;
    private JToolBar.Separator jSeparator1;
    private KnowledgeBaseStateObserverMenuItem journalsManagerMenuItem;
    private JMenu journalsMenu;
    private JMenu knowledgeBaseMenu;
    private JMenuItem loadAnalysisMenuItem;
    private JMenuBar mainMenuBar;
    private JPanel mainPanel;
    private KnowledgeBaseStateObserverMenuItem makeAnalysisMenuItem;
    private NewProjectMenuItem newProjectMenuItem;
    private NewProjectToolBarButton newProjectToolBarButton;
    private OpenProjectMenuItem openProjectMenuItem;
    private OpenProjectToolBarButton openProjectToolBarButton;
    private KnowledgeBaseStateObserverMenuItem periodsManagerMenuItem;
    private JMenu periodsMenu;
    private KnowledgeBaseStateObserverMenuItem publishDatesManagerMenuItem;
    private JMenu publishDatesMenu;
    private RedoMenuItem redoMenuItem1;
    private RedoToolBarButton redoToolBarButton;
    private KnowledgeBaseStateObserverMenuItem referenceGroupManualSetMenuItem;
    private JMenu referenceGroupMenu;
    private KnowledgeBaseStateObserverMenuItem referenceGroupStatisticsMenuItem;
    private KnowledgeBaseStateObserverMenuItem referenceSourceGroupManualSetMenuItem;
    private JMenu referenceSourceMenu;
    private KnowledgeBaseStateObserverMenuItem referencesGroupsManagerMenuItem;
    private KnowledgeBaseStateObserverMenuItem referencesManagerMenuItem;
    private JMenu referencesMenu;
    private KnowledgeBaseStateObserverMenuItem referencesSourceGroupsManagerMenuItem;
    private KnowledgeBaseStateObserverMenuItem referencesSourceManagerMenuItem;
    private JPopupMenu.Separator separator1;
    private JPopupMenu.Separator separator2;
    private JPopupMenu.Separator separator3;
    private JMenu statisticMenu;
    private JMenu subjectCategoriesMenu;
    private KnowledgeBaseStateObserverMenuItem subjectCategoriesMenuItem;
    private JPanel toolBarPanel;
    private UndoMenuItem undoMenuItem1;
    private UndoToolBarButton undoToolBarButton;
    private KnowledgeBaseStateObserverMenuItem wordGroupManualSetMenuItem;
    private JMenu wordGroupMenu;
    private KnowledgeBaseStateObserverMenuItem wordGroupStatisticsMenuItem;
    private KnowledgeBaseStateObserverMenuItem wordsGroupsManagerMenuItem;
    private KnowledgeBaseStateObserverMenuItem wordsManagerMenuItem;
    private JMenu wordsMenu;
    private AffiliationManager affiliationManger = new AffiliationManager();
    private AuthorManager authorManager = new AuthorManager();
    private AuthorGroupManager authorGroupManager = new AuthorGroupManager();
    private AuthorReferenceGroupManager authorReferenceGroupManager = new AuthorReferenceGroupManager();
    private AuthorReferenceManager authorReferenceManager = new AuthorReferenceManager();
    private DocumentManager documentManager = new DocumentManager();
    private JournalManager journalManager = new JournalManager();
    private PeriodManager periodManager = new PeriodManager();
    private PublishDateManager publishDateManager = new PublishDateManager();
    private ReferenceManager referenceManager = new ReferenceManager();
    private ReferenceGroupManager referenceGroupManager = new ReferenceGroupManager();
    private ReferenceSourceManager referenceSourceManager = new ReferenceSourceManager();
    private ReferenceSourceGroupManager referenceSourceGroup = new ReferenceSourceGroupManager();
    private SubjectCategoryManager subjectCategoyManager = new SubjectCategoryManager();
    private WordGroupManager wordGroupManager = new WordGroupManager();
    private WordManager wordManager = new WordManager();
    private AuthorGroupManualSetManager authorGroupManualSetManager = new AuthorGroupManualSetManager();
    private AuthorReferenceGroupManualSetManager authorReferenceGroupManualSetManager = new AuthorReferenceGroupManualSetManager();
    private ReferenceGroupManualSetManager referenceGroupManualSetManager = new ReferenceGroupManualSetManager();
    private ReferenceSourceGroupManualSetManager referenceSourceGroupManualSetManager = new ReferenceSourceGroupManualSetManager();
    private WordGroupManualSetManager wordGroupManualSetManager = new WordGroupManualSetManager();
    private AboutDialog aboutDialog = new AboutDialog(this);

    public MainFrame() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/logoApp.png")));
        this.initComponents();
        CursorManager.getInstance().init(this);
        AddDialogManager.getInstance().init(this);
        EditDialogManager.getInstance().init(this);
        JoinEntitiesDialogManager.getInstance().init(this);
        MoveToGroupDialogManager.getInstance().init(this);
        WizardManager.getInstance().init(this);
        AnalysisViewManager.getInstance().init(this);
        ErrorDialogManager.getInstance().init(this);
        GlobalReplaceDialogManager.getInstance().init(this);
        StatisticDialogManager.getInstance().init(this);
    }

    private void finish() {
        int returnVal = JOptionPane.showConfirmDialog(this, "Do you want to close the tool?", "Close tool", 0, 3);
        if (returnVal == 0) {
            if (CurrentProject.getInstance().isKnowledbaseLoaded()) {
                try {
                    CurrentProject.getInstance().close();
                }
                catch (KnowledgeBaseException e) {
                    e.printStackTrace(System.err);
                }
            }
            this.dispose();
            System.out.println("Finish.");
            System.exit(0);
        }
    }

    public void clearMainPanel() {
        this.mainPanel.removeAll();
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private void initComponents() {
        this.toolBarPanel = new JPanel();
        this.fileToolBar = new JToolBar();
        this.newProjectToolBarButton = new NewProjectToolBarButton();
        this.openProjectToolBarButton = new OpenProjectToolBarButton();
        this.editToolBar = new JToolBar();
        this.jSeparator1 = new JToolBar.Separator();
        this.undoToolBarButton = new UndoToolBarButton();
        this.redoToolBarButton = new RedoToolBarButton();
        this.mainPanel = new JPanel();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newProjectMenuItem = new NewProjectMenuItem();
        this.openProjectMenuItem = new OpenProjectMenuItem();
        this.closeProjectMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.separator1 = new JPopupMenu.Separator();
        this.addFilesMenu = new JMenu();
        this.importFromISIWoSMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.importFromRISMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.importFromCsvMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.exportMenu = new JMenu();
        this.exportGroupsMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.importMenu = new JMenu();
        this.importGroupsMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.separator2 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.globalReplaceMenu = new JMenu();
        this.globalReplaceAffiliationMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceAuthorMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceAuthorGroupMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceAuthorReferenceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceAuthorReferenceGroupMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceJournalMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceDocumentMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplacePeriodMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplacePublishDateMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceReferenceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceReferenceGroupMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceReferenceSourceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceReferenceSourceGroupMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceSubjectCategoryMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceWordMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.globalReplaceWordGroupMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.separator3 = new JPopupMenu.Separator();
        this.undoMenuItem1 = new UndoMenuItem();
        this.redoMenuItem1 = new RedoMenuItem();
        this.knowledgeBaseMenu = new JMenu();
        this.authorsMenu = new JMenu();
        this.authorsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.authorsGroupsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.affiliationsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.documentsMenu = new JMenu();
        this.documentsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.journalsMenu = new JMenu();
        this.journalsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referencesMenu = new JMenu();
        this.referencesManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referencesGroupsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.authorsReferenceManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.authorsReferencesGroupManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referencesSourceManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referencesSourceGroupsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.periodsMenu = new JMenu();
        this.periodsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.publishDatesMenu = new JMenu();
        this.publishDatesManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.subjectCategoriesMenu = new JMenu();
        this.subjectCategoriesMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.wordsMenu = new JMenu();
        this.wordsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.wordsGroupsManagerMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.groupSetMenu = new JMenu();
        this.authorGroupMenu = new JMenu();
        this.authorGroupManualSetMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.findSimilarAuthorsByDistanceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.authorReferenceGroupMenu = new JMenu();
        this.authorReferenceGroupManualSetMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.findSimilarAuthorReferencesByDistanceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referenceGroupMenu = new JMenu();
        this.referenceGroupManualSetMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.findSimilarReferencesByDistanceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referenceSourceMenu = new JMenu();
        this.referenceSourceGroupManualSetMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.findSimilarReferenceSourcesByDistanceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.wordGroupMenu = new JMenu();
        this.wordGroupManualSetMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.findSimilarWordsByPluralsMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.findSimilarWordsByDistanceMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.analysisMenu = new JMenu();
        this.makeAnalysisMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.loadAnalysisMenuItem = new JMenuItem();
        this.statisticMenu = new JMenu();
        this.authorGroupStatisticsMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.referenceGroupStatisticsMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.wordGroupStatisticsMenuItem = new KnowledgeBaseStateObserverMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("SciMAT 1.1.01");
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }
        });
        this.toolBarPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.fileToolBar.setFloatable(false);
        this.fileToolBar.setRollover(true);
        this.newProjectToolBarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.newProjectToolBarButtonActionPerformed(evt);
            }
        });
        this.fileToolBar.add(this.newProjectToolBarButton);
        this.openProjectToolBarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openProjectToolBarButtonActionPerformed(evt);
            }
        });
        this.fileToolBar.add(this.openProjectToolBarButton);
        this.editToolBar.setFloatable(false);
        this.editToolBar.setRollover(true);
        this.editToolBar.add(this.jSeparator1);
        this.undoToolBarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.undoToolBarButtonActionPerformed(evt);
            }
        });
        this.editToolBar.add(this.undoToolBarButton);
        this.redoToolBarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.redoToolBarButtonActionPerformed(evt);
            }
        });
        this.editToolBar.add(this.redoToolBarButton);
        GroupLayout toolBarPanelLayout = new GroupLayout(this.toolBarPanel);
        this.toolBarPanel.setLayout(toolBarPanelLayout);
        toolBarPanelLayout.setHorizontalGroup(toolBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(toolBarPanelLayout.createSequentialGroup().addComponent(this.fileToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editToolBar, -2, -1, -2).addContainerGap(815, Short.MAX_VALUE)));
        toolBarPanelLayout.setVerticalGroup(toolBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(toolBarPanelLayout.createSequentialGroup().addGroup(toolBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileToolBar, -2, 25, -2).addComponent(this.editToolBar, -2, 25, -2)).addContainerGap()));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        this.fileMenu.setText("File");
        this.newProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newProjectMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/newProject16x16.png")));
        this.newProjectMenuItem.setText("New project");
        this.newProjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.newProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newProjectMenuItem);
        this.openProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openProjectMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/openProject16x16.png")));
        this.openProjectMenuItem.setText("Open project");
        this.openProjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProjectMenuItem);
        this.closeProjectMenuItem.setText("Close project");
        this.closeProjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.closeProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeProjectMenuItem);
        this.fileMenu.add(this.separator1);
        this.addFilesMenu.setText("Add files");
        this.importFromISIWoSMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/Document-Add16x16.png")));
        this.importFromISIWoSMenuItem.setText("In ISIWoS format");
        this.importFromISIWoSMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importFromISIWoSMenuItemActionPerformed(evt);
            }
        });
        this.addFilesMenu.add(this.importFromISIWoSMenuItem);
        this.importFromRISMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/Document-Add16x16.png")));
        this.importFromRISMenuItem.setText("In RIS format");
        this.importFromRISMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importFromRISMenuItemActionPerformed(evt);
            }
        });
        this.addFilesMenu.add(this.importFromRISMenuItem);
        this.importFromCsvMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/Document-Add16x16.png")));
        this.importFromCsvMenuItem.setText("In Csv format");
        this.importFromCsvMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importFromCsvMenuItemActionPerformed(evt);
            }
        });
        this.addFilesMenu.add(this.importFromCsvMenuItem);
        this.fileMenu.add(this.addFilesMenu);
        this.exportMenu.setText("Export");
        this.exportGroupsMenuItem.setText("Groups");
        this.exportGroupsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exportGroupsMenuItemActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.exportGroupsMenuItem);
        this.fileMenu.add(this.exportMenu);
        this.importMenu.setText("Import");
        this.importGroupsMenuItem.setText("Groups");
        this.importGroupsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importGroupsMenuItemActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importGroupsMenuItem);
        this.fileMenu.add(this.importMenu);
        this.fileMenu.add(this.separator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.globalReplaceMenu.setText("Global replace");
        this.globalReplaceAffiliationMenuItem.setText("Affiliation");
        this.globalReplaceAffiliationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceAffiliationMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceAffiliationMenuItem);
        this.globalReplaceAuthorMenuItem.setText("Author");
        this.globalReplaceAuthorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceAuthorMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceAuthorMenuItem);
        this.globalReplaceAuthorGroupMenuItem.setText("Author Group");
        this.globalReplaceAuthorGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceAuthorGroupMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceAuthorGroupMenuItem);
        this.globalReplaceAuthorReferenceMenuItem.setText("Author-Reference");
        this.globalReplaceAuthorReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceAuthorReferenceMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceAuthorReferenceMenuItem);
        this.globalReplaceAuthorReferenceGroupMenuItem.setText("Author-Reference Group");
        this.globalReplaceAuthorReferenceGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceAuthorReferenceGroupMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceAuthorReferenceGroupMenuItem);
        this.globalReplaceJournalMenuItem.setText("Journal");
        this.globalReplaceJournalMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceJournalMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceJournalMenuItem);
        this.globalReplaceDocumentMenuItem.setText("Document");
        this.globalReplaceDocumentMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceDocumentMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceDocumentMenuItem);
        this.globalReplacePeriodMenuItem.setText("Period");
        this.globalReplacePeriodMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplacePeriodMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplacePeriodMenuItem);
        this.globalReplacePublishDateMenuItem.setText("Publish date");
        this.globalReplacePublishDateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplacePublishDateMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplacePublishDateMenuItem);
        this.globalReplaceReferenceMenuItem.setText("Reference");
        this.globalReplaceReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceReferenceMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceReferenceMenuItem);
        this.globalReplaceReferenceGroupMenuItem.setText("Reference Group");
        this.globalReplaceReferenceGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceReferenceGroupMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceReferenceGroupMenuItem);
        this.globalReplaceReferenceSourceMenuItem.setText("Reference-Source");
        this.globalReplaceReferenceSourceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceReferenceSourceMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceReferenceSourceMenuItem);
        this.globalReplaceReferenceSourceGroupMenuItem.setText("Reference-Source Group");
        this.globalReplaceReferenceSourceGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceReferenceSourceGroupMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceReferenceSourceGroupMenuItem);
        this.globalReplaceSubjectCategoryMenuItem.setText("Subject Category");
        this.globalReplaceSubjectCategoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceSubjectCategoryMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceSubjectCategoryMenuItem);
        this.globalReplaceWordMenuItem.setText("Word");
        this.globalReplaceWordMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceWordMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceWordMenuItem);
        this.globalReplaceWordGroupMenuItem.setText("Word Group");
        this.globalReplaceWordGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.globalReplaceWordGroupMenuItemActionPerformed(evt);
            }
        });
        this.globalReplaceMenu.add(this.globalReplaceWordGroupMenuItem);
        this.editMenu.add(this.globalReplaceMenu);
        this.editMenu.add(this.separator3);
        this.undoMenuItem1.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-undo16x16.png")));
        this.editMenu.add(this.undoMenuItem1);
        this.redoMenuItem1.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-redo16x16.png")));
        this.editMenu.add(this.redoMenuItem1);
        this.mainMenuBar.add(this.editMenu);
        this.knowledgeBaseMenu.setText("Knowledge base");
        this.authorsMenu.setText("Authors");
        this.authorsManagerMenuItem.setText("Authors manager");
        this.authorsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorsManagerMenuItemActionPerformed(evt);
            }
        });
        this.authorsMenu.add(this.authorsManagerMenuItem);
        this.authorsGroupsManagerMenuItem.setText("Authors groups manager");
        this.authorsGroupsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorsGroupsManagerMenuItemActionPerformed(evt);
            }
        });
        this.authorsMenu.add(this.authorsGroupsManagerMenuItem);
        this.affiliationsManagerMenuItem.setText("Affiliations manager");
        this.affiliationsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.affiliationsManagerMenuItemActionPerformed(evt);
            }
        });
        this.authorsMenu.add(this.affiliationsManagerMenuItem);
        this.knowledgeBaseMenu.add(this.authorsMenu);
        this.documentsMenu.setText("Documents");
        this.documentsManagerMenuItem.setText("Documents manager");
        this.documentsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.documentsManagerMenuItemActionPerformed(evt);
            }
        });
        this.documentsMenu.add(this.documentsManagerMenuItem);
        this.knowledgeBaseMenu.add(this.documentsMenu);
        this.journalsMenu.setText("Journals");
        this.journalsManagerMenuItem.setText("Journals manager");
        this.journalsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.journalsManagerMenuItemActionPerformed(evt);
            }
        });
        this.journalsMenu.add(this.journalsManagerMenuItem);
        this.knowledgeBaseMenu.add(this.journalsMenu);
        this.referencesMenu.setText("References");
        this.referencesManagerMenuItem.setText("References manager");
        this.referencesManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referencesManagerMenuItemActionPerformed(evt);
            }
        });
        this.referencesMenu.add(this.referencesManagerMenuItem);
        this.referencesGroupsManagerMenuItem.setText("References groups manager");
        this.referencesGroupsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referencesGroupsManagerMenuItemActionPerformed(evt);
            }
        });
        this.referencesMenu.add(this.referencesGroupsManagerMenuItem);
        this.authorsReferenceManagerMenuItem.setText("Authors-reference manager");
        this.authorsReferenceManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorsReferenceManagerMenuItemActionPerformed(evt);
            }
        });
        this.referencesMenu.add(this.authorsReferenceManagerMenuItem);
        this.authorsReferencesGroupManagerMenuItem.setText("Authors-reference groups manager");
        this.authorsReferencesGroupManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorsReferencesGroupManagerMenuItemActionPerformed(evt);
            }
        });
        this.referencesMenu.add(this.authorsReferencesGroupManagerMenuItem);
        this.referencesSourceManagerMenuItem.setText("Sources-reference manager");
        this.referencesSourceManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referencesSourceManagerMenuItemActionPerformed(evt);
            }
        });
        this.referencesMenu.add(this.referencesSourceManagerMenuItem);
        this.referencesSourceGroupsManagerMenuItem.setText("Sources-reference groups manager");
        this.referencesSourceGroupsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referencesSourceGroupsManagerMenuItemActionPerformed(evt);
            }
        });
        this.referencesMenu.add(this.referencesSourceGroupsManagerMenuItem);
        this.knowledgeBaseMenu.add(this.referencesMenu);
        this.periodsMenu.setText("Periods");
        this.periodsManagerMenuItem.setText("Periods manager");
        this.periodsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.periodsManagerMenuItemActionPerformed(evt);
            }
        });
        this.periodsMenu.add(this.periodsManagerMenuItem);
        this.knowledgeBaseMenu.add(this.periodsMenu);
        this.publishDatesMenu.setText("Publish dates");
        this.publishDatesManagerMenuItem.setText("Publish dates manager");
        this.publishDatesManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.publishDatesManagerMenuItemActionPerformed(evt);
            }
        });
        this.publishDatesMenu.add(this.publishDatesManagerMenuItem);
        this.knowledgeBaseMenu.add(this.publishDatesMenu);
        this.subjectCategoriesMenu.setText("Subject categories");
        this.subjectCategoriesMenuItem.setText("Subject categories manager");
        this.subjectCategoriesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.subjectCategoriesMenuItemActionPerformed(evt);
            }
        });
        this.subjectCategoriesMenu.add(this.subjectCategoriesMenuItem);
        this.knowledgeBaseMenu.add(this.subjectCategoriesMenu);
        this.wordsMenu.setText("Words");
        this.wordsManagerMenuItem.setText("Words manager");
        this.wordsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.wordsManagerMenuItemActionPerformed(evt);
            }
        });
        this.wordsMenu.add(this.wordsManagerMenuItem);
        this.wordsGroupsManagerMenuItem.setText("Words groups manager");
        this.wordsGroupsManagerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.wordsGroupsManagerMenuItemActionPerformed(evt);
            }
        });
        this.wordsMenu.add(this.wordsGroupsManagerMenuItem);
        this.knowledgeBaseMenu.add(this.wordsMenu);
        this.mainMenuBar.add(this.knowledgeBaseMenu);
        this.groupSetMenu.setText("Group set");
        this.authorGroupMenu.setText("Author");
        this.authorGroupManualSetMenuItem.setText("Author group manual set");
        this.authorGroupManualSetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorGroupManualSetMenuItemActionPerformed(evt);
            }
        });
        this.authorGroupMenu.add(this.authorGroupManualSetMenuItem);
        this.findSimilarAuthorsByDistanceMenuItem.setText("Find similar authors by distances");
        this.findSimilarAuthorsByDistanceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.findSimilarAuthorsByDistanceMenuItemActionPerformed(evt);
            }
        });
        this.authorGroupMenu.add(this.findSimilarAuthorsByDistanceMenuItem);
        this.groupSetMenu.add(this.authorGroupMenu);
        this.authorReferenceGroupMenu.setText("Author-reference");
        this.authorReferenceGroupManualSetMenuItem.setText("Authors-reference group manual set");
        this.authorReferenceGroupManualSetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorReferenceGroupManualSetMenuItemActionPerformed(evt);
            }
        });
        this.authorReferenceGroupMenu.add(this.authorReferenceGroupManualSetMenuItem);
        this.findSimilarAuthorReferencesByDistanceMenuItem.setText("Find similar author references by distances");
        this.findSimilarAuthorReferencesByDistanceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.findSimilarAuthorReferencesByDistanceMenuItemActionPerformed(evt);
            }
        });
        this.authorReferenceGroupMenu.add(this.findSimilarAuthorReferencesByDistanceMenuItem);
        this.groupSetMenu.add(this.authorReferenceGroupMenu);
        this.referenceGroupMenu.setText("Reference");
        this.referenceGroupManualSetMenuItem.setText("Reference group manual set");
        this.referenceGroupManualSetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referenceGroupManualSetMenuItemActionPerformed(evt);
            }
        });
        this.referenceGroupMenu.add(this.referenceGroupManualSetMenuItem);
        this.findSimilarReferencesByDistanceMenuItem.setText("Find similar references by distances");
        this.findSimilarReferencesByDistanceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.findSimilarReferencesByDistanceMenuItemActionPerformed(evt);
            }
        });
        this.referenceGroupMenu.add(this.findSimilarReferencesByDistanceMenuItem);
        this.groupSetMenu.add(this.referenceGroupMenu);
        this.referenceSourceMenu.setText("Source-reference");
        this.referenceSourceGroupManualSetMenuItem.setText("Sources-reference group manual set");
        this.referenceSourceGroupManualSetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referenceSourceGroupManualSetMenuItemActionPerformed(evt);
            }
        });
        this.referenceSourceMenu.add(this.referenceSourceGroupManualSetMenuItem);
        this.findSimilarReferenceSourcesByDistanceMenuItem.setText("Find similar sources-reference by distances");
        this.findSimilarReferenceSourcesByDistanceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.findSimilarReferenceSourcesByDistanceMenuItemActionPerformed(evt);
            }
        });
        this.referenceSourceMenu.add(this.findSimilarReferenceSourcesByDistanceMenuItem);
        this.groupSetMenu.add(this.referenceSourceMenu);
        this.wordGroupMenu.setText("Word");
        this.wordGroupManualSetMenuItem.setText("Word group manual set");
        this.wordGroupManualSetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.wordGroupManualSetMenuItemActionPerformed(evt);
            }
        });
        this.wordGroupMenu.add(this.wordGroupManualSetMenuItem);
        this.findSimilarWordsByPluralsMenuItem.setText("Find similar words by plurals");
        this.findSimilarWordsByPluralsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.findSimilarWordsByPluralsMenuItemActionPerformed(evt);
            }
        });
        this.wordGroupMenu.add(this.findSimilarWordsByPluralsMenuItem);
        this.findSimilarWordsByDistanceMenuItem.setText("Find similar words by distances");
        this.findSimilarWordsByDistanceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.findSimilarWordsByDistanceMenuItemActionPerformed(evt);
            }
        });
        this.wordGroupMenu.add(this.findSimilarWordsByDistanceMenuItem);
        this.groupSetMenu.add(this.wordGroupMenu);
        this.mainMenuBar.add(this.groupSetMenu);
        this.analysisMenu.setText("Analysis");
        this.makeAnalysisMenuItem.setText("Make analysis");
        this.makeAnalysisMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.makeAnalysisMenuItemActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.makeAnalysisMenuItem);
        this.loadAnalysisMenuItem.setText("Load analysis");
        this.loadAnalysisMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.loadAnalysisMenuItemActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.loadAnalysisMenuItem);
        this.mainMenuBar.add(this.analysisMenu);
        this.statisticMenu.setText("Statistics");
        this.authorGroupStatisticsMenuItem.setText("Author groups statistics");
        this.authorGroupStatisticsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.authorGroupStatisticsMenuItemActionPerformed(evt);
            }
        });
        this.statisticMenu.add(this.authorGroupStatisticsMenuItem);
        this.referenceGroupStatisticsMenuItem.setText("Reference groups statistics");
        this.referenceGroupStatisticsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referenceGroupStatisticsMenuItemActionPerformed(evt);
            }
        });
        this.statisticMenu.add(this.referenceGroupStatisticsMenuItem);
        this.wordGroupStatisticsMenuItem.setText("Word groups statistics");
        this.wordGroupStatisticsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.wordGroupStatisticsMenuItemActionPerformed(evt);
            }
        });
        this.statisticMenu.add(this.wordGroupStatisticsMenuItem);
        this.mainMenuBar.add(this.statisticMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBarPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mainPanel, -1, 959, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBarPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainPanel, -1, 537, Short.MAX_VALUE)));
        this.pack();
    }

    private void undoToolBarButtonActionPerformed(ActionEvent evt) {
        UndoStack.undo();
    }

    private void redoToolBarButtonActionPerformed(ActionEvent evt) {
        UndoStack.redo();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.finish();
    }

    private void openProjectMenuItemActionPerformed(ActionEvent evt) {
        new LoadProjectTask(this.rootPane).execute();
    }

    private void openProjectToolBarButtonActionPerformed(ActionEvent evt) {
        new LoadProjectTask(this.rootPane).execute();
    }

    private void documentsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.documentManager).execute();
    }

    private void authorsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.authorManager).execute();
    }

    private void authorsGroupsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.authorGroupManager).execute();
    }

    private void affiliationsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.affiliationManger).execute();
    }

    private void journalsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.journalManager).execute();
    }

    private void referencesManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.referenceManager).execute();
    }

    private void referencesGroupsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.referenceGroupManager).execute();
    }

    private void authorsReferenceManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.authorReferenceManager).execute();
    }

    private void authorsReferencesGroupManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.authorReferenceGroupManager).execute();
    }

    private void referencesSourceManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.referenceSourceManager).execute();
    }

    private void referencesSourceGroupsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.referenceSourceGroup).execute();
    }

    private void periodsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.periodManager).execute();
    }

    private void publishDatesManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.publishDateManager).execute();
    }

    private void subjectCategoriesMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.subjectCategoyManager).execute();
    }

    private void wordsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.wordManager).execute();
    }

    private void wordsGroupsManagerMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.wordGroupManager).execute();
    }

    private void authorGroupManualSetMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.authorGroupManualSetManager).execute();
    }

    private void authorReferenceGroupManualSetMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.authorReferenceGroupManualSetManager).execute();
    }

    private void referenceGroupManualSetMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.referenceGroupManualSetManager).execute();
    }

    private void referenceSourceGroupManualSetMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.referenceSourceGroupManualSetManager).execute();
    }

    private void wordGroupManualSetMenuItemActionPerformed(ActionEvent evt) {
        new ShowManagerTask(this.mainPanel, this.wordGroupManualSetManager).execute();
    }

    private void newProjectToolBarButtonActionPerformed(ActionEvent evt) {
        WizardManager.getInstance().showNewProject();
    }

    private void newProjectMenuItemActionPerformed(ActionEvent evt) {
        WizardManager.getInstance().showNewProject();
    }

    private void closeProjectMenuItemActionPerformed(ActionEvent evt) {
        new CloseProjectTask(this).execute();
    }

    private void makeAnalysisMenuItemActionPerformed(ActionEvent evt) {
        WizardManager.getInstance().showMakeAnalysis();
    }

    private void loadAnalysisMenuItemActionPerformed(ActionEvent evt) {
        new LoadAnalysisTask(this.rootPane).execute();
    }

    private void findSimilarAuthorsByDistanceMenuItemActionPerformed(ActionEvent evt) {
        new FindSimilarAuthorsWithoutGroupByDistanceTask(this).execute();
    }

    private void findSimilarAuthorReferencesByDistanceMenuItemActionPerformed(ActionEvent evt) {
        new FindSimilarAuthorReferencesWithoutGroupByDistanceTask(this).execute();
    }

    private void findSimilarReferencesByDistanceMenuItemActionPerformed(ActionEvent evt) {
        new FindSimilarReferencesWithoutGroupByDistanceTask(this).execute();
    }

    private void findSimilarReferenceSourcesByDistanceMenuItemActionPerformed(ActionEvent evt) {
        new FindSimilarReferenceSourcesWithoutGroupByDistanceTask(this).execute();
    }

    private void findSimilarWordsByDistanceMenuItemActionPerformed(ActionEvent evt) {
        new FindSimilarWordsWithoutGroupByDistanceTask(this).execute();
    }

    private void findSimilarWordsByPluralsMenuItemActionPerformed(ActionEvent evt) {
        new FindSimilarWordsWithoutGroupByPluralsTask(this).execute();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        this.aboutDialog.setVisible(true);
    }

    private void importFromISIWoSMenuItemActionPerformed(ActionEvent evt) {
        new ImportFileTask(ImportFileTask.FormatAvailable.ISIWoS, this).execute();
    }

    private void exportGroupsMenuItemActionPerformed(ActionEvent evt) {
        new ExportGroupTask(this.rootPane).execute();
    }

    private void importGroupsMenuItemActionPerformed(ActionEvent evt) {
        new ImportGroupTask(this.rootPane).execute();
    }

    private void importFromRISMenuItemActionPerformed(ActionEvent evt) {
        new ImportFileTask(ImportFileTask.FormatAvailable.RIS, this).execute();
    }

    private void globalReplaceAffiliationMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalAffiliationGlobalReplaceDialog();
    }

    private void globalReplaceAuthorMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalAuthorGlobalReplaceDialog();
    }

    private void globalReplaceAuthorGroupMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalAuthorGroupGlobalReplaceDialog();
    }

    private void globalReplaceAuthorReferenceMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalAuthorReferenceGlobalReplaceDialog();
    }

    private void globalReplaceAuthorReferenceGroupMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalAuthorReferenceGroupGlobalReplaceDialog();
    }

    private void globalReplaceJournalMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalJournalGlobalReplaceDialog();
    }

    private void globalReplaceDocumentMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalDocumentGlobalReplaceDialog();
    }

    private void globalReplacePeriodMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalPeriodGlobalReplaceDialog();
    }

    private void globalReplaceSubjectCategoryMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalSubjectCategoryGlobalReplaceDialog();
    }

    private void globalReplacePublishDateMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalPublishDateGlobalReplaceDialog();
    }

    private void globalReplaceReferenceMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalReferenceGlobalReplaceDialog();
    }

    private void globalReplaceReferenceGroupMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalReferenceGroupGlobalReplaceDialog();
    }

    private void globalReplaceReferenceSourceMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalReferenceSourceGlobalReplaceDialog();
    }

    private void globalReplaceReferenceSourceGroupMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalReferenceSourceGroupGlobalReplaceDialog();
    }

    private void globalReplaceWordMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalWordGlobalReplaceDialog();
    }

    private void globalReplaceWordGroupMenuItemActionPerformed(ActionEvent evt) {
        GlobalReplaceDialogManager.getInstance().showGlobalWordGroupGlobalReplaceDialog();
    }

    private void wordGroupStatisticsMenuItemActionPerformed(ActionEvent evt) {
        StatisticDialogManager.getInstance().showWordGroupStatisticDialog();
    }

    private void authorGroupStatisticsMenuItemActionPerformed(ActionEvent evt) {
        StatisticDialogManager.getInstance().showAuthorGroupStatisticDialog();
    }

    private void referenceGroupStatisticsMenuItemActionPerformed(ActionEvent evt) {
        StatisticDialogManager.getInstance().showReferenceGroupStatisticDialog();
    }

    private void importFromCsvMenuItemActionPerformed(ActionEvent evt) {
        new ImportFileTask(ImportFileTask.FormatAvailable.CSV, this).execute();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.finish();
    }
}

