/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import scimat.analysis.AnalysisPeriodResult;
import scimat.analysis.GlobalAnalysisResult;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.analysis.performance.quality.HIndex;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class TestIndexApp {
    private String analysisFile;
    private GlobalAnalysisResult globalAnalysisResult;

    public TestIndexApp(String analysisFile) {
        this.analysisFile = analysisFile;
    }

    public void execute() throws Exception {
        System.out.println("Loading the analysis...");
        this.loadAnalysis(this.analysisFile);
        System.out.println("Generating the output...");
        this.generateOutput();
    }

    private void loadAnalysis(String file) throws ClassNotFoundException, IOException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        this.globalAnalysisResult = (GlobalAnalysisResult)ois.readObject();
        ois.close();
    }

    private void generateOutput() throws FileNotFoundException, KnowledgeBaseException {
        ArrayList<Period> periods = this.globalAnalysisResult.getAnalysisConfiguration().getPeriods();
        for (int periodResultIndex = 0; periodResultIndex < this.globalAnalysisResult.getAnalysisPeriodResultsCount(); ++periodResultIndex) {
            HIndex hIndex = new HIndex(this.globalAnalysisResult.getAnalysisPeriodResult(periodResultIndex).getPreprocessedDataset());
            AnalysisPeriodResult analysisPeriodResult = this.globalAnalysisResult.getAnalysisPeriodResult(periodResultIndex);
            System.out.println("Min Frequency: " + this.globalAnalysisResult.getAnalysisConfiguration().getMinFrequency(periodResultIndex));
            System.out.println("Min Co-Occurrence: " + this.globalAnalysisResult.getAnalysisConfiguration().getMinCoOccurrence(periodResultIndex));
            System.out.println("Number of items: " + analysisPeriodResult.getPreprocessedDataset().getItemsCount());
            for (int clusterIndex = 0; clusterIndex < analysisPeriodResult.getClusterSet().getClustersCount(); ++clusterIndex) {
                Cluster cluster = analysisPeriodResult.getClusterSet().getCluster(clusterIndex);
                ArrayList<String> propertyKeys = cluster.getProperties().getKeyList();
                Double value = hIndex.calculateMeasure((DocumentSet)cluster.getProperties().getProperty("coreDocuments").getValue());
                System.out.println(value);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            System.err.println("Incorrect arguments.");
        } else {
            try {
                new TestIndexApp("informe").execute();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

