/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.TreeSet;
import org.sqlite.SQLiteConfig;

public class PreprocessingHIndexStudyApp {
    public void execute() throws Exception {
        this.updateDoiMatched();
    }

    public static void main(String[] args) {
        try {
            new PreprocessingHIndexStudyApp().execute();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.out.println("End.");
    }

    private void printRecordWitoutDOI() throws Exception {
        String line;
        BufferedReader input = null;
        PrintStream out = null;
        input = new BufferedReader(new InputStreamReader(new FileInputStream("webBD.txt")));
        out = new PrintStream("webBD-recordWithoutDoi.txt");
        int cont = 0;
        while ((line = input.readLine()) != null) {
            int pos = line.lastIndexOf("doi:");
            if (pos != -1) continue;
            out.println(line);
            ++cont;
        }
        System.out.println("Records without doi: " + cont);
        input.close();
        out.close();
    }

    private void updateDoiMatched() throws Exception {
        String doi;
        String line;
        BufferedReader input = null;
        input = new BufferedReader(new InputStreamReader(new FileInputStream("webBD.txt")));
        TreeSet<String> dois = new TreeSet<String>();
        while ((line = input.readLine()) != null) {
            int pos = line.lastIndexOf("doi:");
            int lastDot = line.lastIndexOf(".");
            if (pos == -1) continue;
            doi = line.substring(pos + 4, lastDot).trim();
            dois.add(doi);
        }
        input.close();
        Class.forName("org.sqlite.JDBC");
        SQLiteConfig config = new SQLiteConfig();
        config.enforceForeignKeys(true);
        Connection conn = DriverManager.getConnection("jdbc:sqlite:hIndex-ConceptualStudy.sqlite", config.toProperties());
        Statement stat = conn.createStatement();
        int cont = 0;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> titles = new ArrayList<String>();
        ResultSet rs = stat.executeQuery("SELECT d.idDocument, d.title, d.doi FROM Document d;");
        while (rs.next()) {
            doi = rs.getString("doi");
            if (doi == null || !dois.contains(doi)) continue;
            ids.add(rs.getInt("idDocument"));
            titles.add("#####" + rs.getString("title"));
            ++cont;
        }
        System.out.println(cont);
        rs.close();
        stat.close();
        PreparedStatement prepareStat = conn.prepareStatement("UPDATE Document SET title = ? WHERE idDocument = ?");
        cont = ids.size();
        for (int i = 0; i < cont; ++i) {
            System.out.println(i + " - " + cont);
            prepareStat.clearParameters();
            prepareStat.setString(1, (String)titles.get(i));
            prepareStat.setInt(2, (Integer)ids.get(i));
            prepareStat.executeUpdate();
        }
        prepareStat.close();
        conn.close();
    }

    private void removeDuplicates(String kbPath) throws Exception {
        Class.forName("org.sqlite.JDBC");
        SQLiteConfig config = new SQLiteConfig();
        config.enforceForeignKeys(true);
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + kbPath, config.toProperties());
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT d.idDocument, d.sourceIdentifier, subq.cuenta\nFROM Document d,\n    (SELECT d.sourceIdentifier, count(*) AS cuenta\n     FROM Document d\n     GROUP BY d.sourceIdentifier\n     HAVING count(*) > 1) AS subq\nWHERE d.sourceIdentifier = subq.sourceIdentifier\nGROUP BY d.sourceIdentifier\nHAVING d.idDocument > min(d.idDocument)\nORDER BY d.sourceIdentifier;");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> sourceIdentifiers = new ArrayList<String>();
        while (rs.next()) {
            ids.add(rs.getInt("idDocument"));
            sourceIdentifiers.add(rs.getString("sourceIdentifier"));
        }
        System.out.println();
        rs.close();
        stat.close();
        PreparedStatement prepareStat = conn.prepareStatement("DELETE FROM Document WHERE sourceIdentifier = ? AND idDocument <> ?");
        int cont = ids.size();
        for (int i = 0; i < cont; ++i) {
            System.out.println(i + " - " + cont);
            prepareStat.clearParameters();
            prepareStat.setString(1, (String)sourceIdentifiers.get(i));
            prepareStat.setInt(2, (Integer)ids.get(i));
            prepareStat.executeUpdate();
        }
        prepareStat.close();
        conn.close();
    }
}

