/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class LoadProyectFundacion {
    private static final int __ID_PROYECTO = 0;
    private static final int __TITULO = 1;
    private static final int __TIPO = 2;
    private static final int __FECHA_INICIO = 3;
    private static final int __FECHA_FIN = 4;
    private static final int __PRESUPUESTO = 5;
    private static final int __ID_RESPONSABLE = 6;
    private static final int __NOMBRE_RESPONSABLE = 7;
    private static final int __ID_RESPONSABLE_MARROQUI = 8;
    private static final int __NOMBRE_RESPONSABLE_MARROQUI = 9;
    private static final int __ID_AREA = 10;
    private static final int __NOMBRE_AREA = 11;
    private static final int __ID_ENTIDAD = 12;
    private static final int __NOMBRE_ENTIDAD = 13;

    public void execute() throws IOException {
        BufferedReader input = null;
        try {
            String line;
            KnowledgeBaseManager kbm = new KnowledgeBaseManager();
            kbm.createKnowledgeBase("ProyectoFundacionEuroarabe.sqlite");
            DocumentDAO documentDAO = new DocumentDAO(kbm);
            WordDAO wordDAO = new WordDAO(kbm);
            PublishDateDAO publishDateDAO = new PublishDateDAO(kbm);
            DocumentWordDAO documentWordDAO = new DocumentWordDAO(kbm);
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("dataPreprocessed.txt"), "8859_1"));
            int lineCount = 1;
            while ((line = input.readLine()) != null) {
                PublishDate publishDate;
                System.out.println(lineCount);
                ++lineCount;
                String[] splitLine = line.split("\t");
                Integer documentID = Integer.valueOf(splitLine[0]);
                documentDAO.addDocument(documentID, splitLine[1], "", splitLine[2], 0, "", "FUNDEA", "", "", "", "", false);
                String[] splitTitle = splitLine[1].split(" ");
                for (int i = 0; i < splitTitle.length; ++i) {
                    Word word;
                    String wordName = splitTitle[i];
                    if (wordDAO.checkWord(wordName)) {
                        word = wordDAO.getWord(wordName);
                    } else {
                        Integer wordID = wordDAO.addWord(wordName, false);
                        word = wordDAO.getWord(wordID);
                    }
                    if (documentWordDAO.checkDocumentWord(documentID, word.getWordID())) continue;
                    documentWordDAO.addDocumentWord(documentID, word.getWordID(), false, false, true, false);
                }
                String fullDate = splitLine[3];
                String[] splitDate = fullDate.split("/");
                String year = splitDate[2];
                if (publishDateDAO.checkPublishDate(year, fullDate)) {
                    publishDate = publishDateDAO.getPublishDate(year, fullDate);
                } else {
                    Integer publishDateID = publishDateDAO.addPublishDate(year, fullDate, false);
                    publishDate = publishDateDAO.getPublishDate(publishDateID);
                }
                documentDAO.setPublishDate(documentID, publishDate.getPublishDateID(), false);
            }
            kbm.commit();
            kbm.close();
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
        }
        input.close();
    }

    public static void main(String[] args) {
        try {
            new LoadProyectFundacion().execute();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.out.println("End.");
    }
}

