/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import scimat.analysis.AnalysisPeriodResult;
import scimat.analysis.GlobalAnalysisResult;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.utils.property.PropertyTypes;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class ExtractDocumentsFromAnalysisV1App {
    private String knowledgeBaseFile;
    private String analysisFile;
    private String outputFile;
    private KnowledgeBaseManager kbm;
    private GlobalAnalysisResult globalAnalysisResult;

    public ExtractDocumentsFromAnalysisV1App(String knowledgeBaseFile, String analysisFile, String outputFile) {
        this.knowledgeBaseFile = knowledgeBaseFile;
        this.analysisFile = analysisFile;
        this.outputFile = outputFile;
    }

    public void execute() throws Exception {
        System.out.println("Loading the knowledge base...");
        this.loadKnowledgeBase(this.knowledgeBaseFile);
        System.out.println("Loading the analysis...");
        this.loadAnalysis(this.analysisFile);
        System.out.println("Generating the output...");
        this.generateOutput(this.outputFile);
        this.kbm.close();
    }

    private void loadKnowledgeBase(String file) throws KnowledgeBaseException {
        this.kbm = new KnowledgeBaseManager();
        this.kbm.loadKnowledgeBase(file, true);
    }

    private void loadAnalysis(String file) throws ClassNotFoundException, IOException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        this.globalAnalysisResult = (GlobalAnalysisResult)ois.readObject();
        ois.close();
    }

    private void generateOutput(String file) throws FileNotFoundException, KnowledgeBaseException {
        PrintStream output = new PrintStream(file);
        ArrayList<Period> periods = this.globalAnalysisResult.getAnalysisConfiguration().getPeriods();
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        for (int periodResultIndex = 0; periodResultIndex < this.globalAnalysisResult.getAnalysisPeriodResultsCount(); ++periodResultIndex) {
            output.println("########################################################################");
            output.println("Period: " + periods.get(periodResultIndex).getName());
            output.println("########################################################################");
            System.out.println(" Doing period " + periodResultIndex + "...");
            AnalysisPeriodResult analysisPeriodResult = this.globalAnalysisResult.getAnalysisPeriodResult(periodResultIndex);
            for (int clusterIndex = 0; clusterIndex < analysisPeriodResult.getClusterSet().getClustersCount(); ++clusterIndex) {
                System.out.println("   Doing cluster " + clusterIndex + "...");
                Cluster cluster = analysisPeriodResult.getClusterSet().getCluster(clusterIndex);
                ArrayList<String> propertyKeys = cluster.getProperties().getKeyList();
                for (int propertyIndex = 0; propertyIndex < propertyKeys.size(); ++propertyIndex) {
                    if (!cluster.getProperties().getProperty(propertyKeys.get(propertyIndex)).getType().equals((Object)PropertyTypes.DocumentsProperty)) continue;
                    output.println("\nCluster (" + propertyKeys.get(propertyIndex) + "): " + cluster.getProperties().getProperty("clusterName") + "\n");
                    DocumentSet documentSet = (DocumentSet)cluster.getProperties().getProperty(propertyKeys.get(propertyIndex)).getValue();
                    ArrayList<Integer> documentIDs = documentSet.getDocuments();
                    for (int documentIndex = 0; documentIndex < documentIDs.size(); ++documentIndex) {
                        Document document = documentDAO.getDocument(documentIDs.get(documentIndex));
                        ArrayList<Author> authors = documentDAO.getAuthors(document.getDocumentID());
                        Journal journal = documentDAO.getJournal(document.getDocumentID());
                        PublishDate publishDate = documentDAO.getPublishDate(document.getDocumentID());
                        output.print("  - ");
                        for (int authorIndex = 0; authorIndex < authors.size(); ++authorIndex) {
                            output.print(authors.get(authorIndex).getAuthorName() + ", ");
                        }
                        output.print(document.getTitle() + ". ");
                        output.print(journal.getSource() + " " + document.getVolume() + ":" + document.getIssue() + " ");
                        output.print("(" + publishDate.getYear() + ") ");
                        output.print(document.getBeginPage() + "-" + document.getEndPage() + ". ");
                        output.println("Times cited:" + document.getCitationsCount());
                    }
                }
            }
            output.println();
        }
        output.close();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Incorrect arguments.");
        } else {
            try {
                new ExtractDocumentsFromAnalysisV1App(args[0], args[1], args[2]).execute();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

