/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.util.ArrayList;
import scimat.api.analysis.network.labeller.BasicNodeLabeller;
import scimat.api.analysis.network.labeller.NodeLabelSetter;
import scimat.api.analysis.temporal.EvolutionMapBuilder;
import scimat.api.analysis.temporal.OverlappingMeasure;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnWordsBuilder;
import scimat.api.dataset.networkbuilder.NetworkCoOccurrenceBuilder;
import scimat.api.mapping.clustering.SingleLinkClustering;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.preprocessing.reduction.data.FilterItemByFrequency;
import scimat.api.preprocessing.reduction.network.FilterByEdgeValue;
import scimat.api.similaritymeasure.CoOccurrenceNormalizer;
import scimat.api.similaritymeasure.direct.EquivalenceIndexMeasure;
import scimat.api.similaritymeasure.direct.InclusionIndexMeasure;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class ExperimentApp {
    public void execute() throws KnowledgeBaseException {
        System.out.println("Loading the knowledge base...");
        this.loadKnowledgeBase();
        System.out.println("Making analysis...");
        this.makeExperiment();
    }

    public static void main(String[] args) {
        try {
            new ExperimentApp().execute();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.out.println("End.");
    }

    private void loadKnowledgeBase() throws KnowledgeBaseException {
        CurrentProject.getInstance().loadProyect("FSSandIEEETFS.sqlite");
    }

    private void makeExperiment() throws KnowledgeBaseException {
        ArrayList<PublishDate> publishDates = new ArrayList();
        ArrayList<ClusterSet> clusterSets = new ArrayList<ClusterSet>();
        Dataset[] datasets = new Dataset[5];
        System.out.println("  Building the datasets...");
        for (int i = 0; i < datasets.length; ++i) {
            Period period = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriod(i + 1);
            System.out.println("    Period: " + period);
            publishDates = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPublishDates(period.getPeriodID());
            DatasetBasedOnWordsBuilder datasetBuilder = new DatasetBasedOnWordsBuilder(CurrentProject.getInstance().getKnowledgeBase(), true, false, false);
            datasets[(i + 1) % 5] = datasetBuilder.execute(publishDates);
        }
        System.out.println("  Performing the science mapping process on dataset 1...");
        clusterSets.add(this.doScienceMappingProcess(datasets[0], 3, 2, 3, 12));
        EvolutionMapBuilder evolutionMapBuilder = new EvolutionMapBuilder(new OverlappingMeasure(new InclusionIndexMeasure()));
        evolutionMapBuilder.buildEvolutionMap(clusterSets);
    }

    private ClusterSet doScienceMappingProcess(Dataset dataset, int minFrequency, int minCoOccurrence, int minNetwork, int maxNetwork) {
        System.out.println("    Filtering the datasets (" + minFrequency + ")...");
        FilterItemByFrequency frequencyFilter = new FilterItemByFrequency(minFrequency);
        frequencyFilter.execute(dataset);
        System.out.println("    Building the network...");
        NetworkCoOccurrenceBuilder networkBuilder = new NetworkCoOccurrenceBuilder(dataset);
        UndirectNetworkMatrix network = networkBuilder.execute();
        this.printNeighbord(network);
        System.out.println("    Filtering the network (" + minCoOccurrence + ")...");
        FilterByEdgeValue coOccurrenceFilter = new FilterByEdgeValue(minCoOccurrence);
        coOccurrenceFilter.execute(network);
        this.printNeighbord(network);
        System.out.println("    Normalizing the network...");
        CoOccurrenceNormalizer normalizer = new CoOccurrenceNormalizer(new EquivalenceIndexMeasure());
        normalizer.execute(dataset, network);
        SingleLinkClustering clusterAlgorithm = new SingleLinkClustering(minNetwork, maxNetwork, 0.01);
        ClusterSet clusterSet = clusterAlgorithm.execute(network);
        System.out.println("    Setting a label to each node...");
        NodeLabelSetter nodeLabelAssigner = new NodeLabelSetter(new BasicNodeLabeller(dataset));
        nodeLabelAssigner.execute(clusterSet.getWholeNetwork().getNodes(), "name");
        this.printCluster(clusterSet);
        return clusterSet;
    }

    private void printCluster(ClusterSet clusterSet) {
        for (int i = 0; i < clusterSet.getClustersCount(); ++i) {
            ArrayList<Integer> nodes = clusterSet.getClusters().get(i).getNodes();
            for (int j = 0; j < nodes.size(); ++j) {
                String label = (String)clusterSet.getWholeNetwork().getNode(nodes.get(j)).getProperties().getProperty("name").getValue();
                System.out.print(label + ", ");
            }
            System.out.println();
        }
    }

    private void printNeighbord(UndirectNetworkMatrix network) {
        for (int i = 0; i < network.getNodesCount(); ++i) {
            System.out.println(network.getNeighbours(network.getNodes().get(i)));
        }
    }
}

