/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.sql.SQLException;
import java.util.ArrayList;
import scimat.gui.commands.edit.join.JoinAffiliationEdit;
import scimat.gui.undostack.UndoStack;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorAffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.dao.PeriodDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDatePeriodDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceGroupDAO;
import scimat.model.knowledgebase.dao.SubjectCategoryDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AppTestKB {
    private KnowledgeBaseManager kbm;
    private AffiliationDAO affiliationDAO;
    private AuthorAffiliationDAO authorAffiliationDAO;
    private AuthorDAO authorDAO;
    private AuthorGroupDAO authorGroupDAO;
    private AuthorReferenceDAO authorReferenceDAO;
    private AuthorReferenceGroupDAO authorReferenceGroupDAO;
    private AuthorReferenceReferenceDAO authorReferenceReferenceDAO;
    private DocumentAffiliationDAO documentAffiliationDAO;
    private DocumentAuthorDAO documentAuthorDAO;
    private DocumentDAO documentDAO;
    private DocumentReferenceDAO documentReferenceDAO;
    private DocumentWordDAO documentWordDAO;
    private JournalDAO journalDAO;
    private JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO;
    private PublishDateDAO publishDateDAO;
    private PublishDatePeriodDAO publishDatePeriodDAO;
    private PeriodDAO periodDAO;
    private ReferenceDAO referenceDAO;
    private ReferenceGroupDAO referenceGroupDAO;
    private ReferenceSourceDAO referenceSourceDAO;
    private ReferenceSourceGroupDAO referenceSourceGroupDAO;
    private SubjectCategoryDAO subjectCategoryDAO;
    private WordDAO wordDAO;
    private WordGroupDAO wordGroupDAO;

    public void execute() throws KnowledgeBaseException {
        boolean newKB = true;
        try {
            if (newKB) {
                System.out.println("Creating a new knowledgeBase...");
                this.openKnowledgeBase("KnwoledgeBase.sqlite", newKB);
            } else {
                System.out.println("Loading a knowledgeBase...");
                this.openKnowledgeBase("KnwoledgeBase.sqlite", newKB);
            }
            this.add();
            System.out.println("Before relations");
            System.out.println(this.affiliationDAO.getAffiliation(1));
            System.out.println(this.affiliationDAO.getDocuments(1));
            System.out.println(this.affiliationDAO.getAuthors(1));
            System.out.println(this.affiliationDAO.getAffiliation(2));
            System.out.println(this.affiliationDAO.getDocuments(2));
            System.out.println(this.affiliationDAO.getAuthors(2));
            System.out.println(this.affiliationDAO.getAffiliation(3));
            System.out.println(this.affiliationDAO.getDocuments(3));
            System.out.println(this.affiliationDAO.getAuthors(3));
            this.relations();
            System.out.println("After relations");
            System.out.println(this.affiliationDAO.getAffiliation(1));
            System.out.println(this.affiliationDAO.getDocuments(1));
            System.out.println(this.affiliationDAO.getAuthors(1));
            System.out.println(this.affiliationDAO.getAffiliation(2));
            System.out.println(this.affiliationDAO.getDocuments(2));
            System.out.println(this.affiliationDAO.getAuthors(2));
            System.out.println(this.affiliationDAO.getAffiliation(3));
            System.out.println(this.affiliationDAO.getDocuments(3));
            System.out.println(this.affiliationDAO.getAuthors(3));
            ArrayList<Affiliation> affiliations = new ArrayList<Affiliation>();
            affiliations.add(this.affiliationDAO.getAffiliation(2));
            affiliations.add(this.affiliationDAO.getAffiliation(3));
            JoinAffiliationEdit edit = new JoinAffiliationEdit(affiliations, this.affiliationDAO.getAffiliation(1));
            edit.execute();
            System.out.println("After join");
            System.out.println(this.affiliationDAO.getAffiliation(1));
            System.out.println(this.affiliationDAO.getDocuments(1));
            System.out.println(this.affiliationDAO.getAuthors(1));
            System.out.println(this.affiliationDAO.getAffiliation(2));
            System.out.println(this.affiliationDAO.getDocuments(2));
            System.out.println(this.affiliationDAO.getAuthors(2));
            System.out.println(this.affiliationDAO.getAffiliation(3));
            System.out.println(this.affiliationDAO.getDocuments(3));
            System.out.println(this.affiliationDAO.getAuthors(3));
            System.out.println("After undo");
            UndoStack.undo();
            System.out.println(this.affiliationDAO.getAffiliation(1));
            System.out.println(this.affiliationDAO.getDocuments(1));
            System.out.println(this.affiliationDAO.getAuthors(1));
            System.out.println(this.affiliationDAO.getAffiliation(2));
            System.out.println(this.affiliationDAO.getDocuments(2));
            System.out.println(this.affiliationDAO.getAuthors(2));
            System.out.println(this.affiliationDAO.getAffiliation(3));
            System.out.println(this.affiliationDAO.getDocuments(3));
            System.out.println(this.affiliationDAO.getAuthors(3));
            System.out.println("After redo");
            UndoStack.redo();
            System.out.println(this.affiliationDAO.getAffiliation(1));
            System.out.println(this.affiliationDAO.getDocuments(1));
            System.out.println(this.affiliationDAO.getAuthors(1));
            System.out.println(this.affiliationDAO.getAffiliation(2));
            System.out.println(this.affiliationDAO.getDocuments(2));
            System.out.println(this.affiliationDAO.getAuthors(2));
            System.out.println(this.affiliationDAO.getAffiliation(3));
            System.out.println(this.affiliationDAO.getDocuments(3));
            System.out.println(this.affiliationDAO.getAuthors(3));
            this.kbm.commit();
        }
        catch (KnowledgeBaseException e) {
            try {
                this.kbm.getConnection().rollback();
            }
            catch (SQLException s) {
                s.printStackTrace(System.err);
            }
            this.kbm.close();
            throw e;
        }
    }

    private void openKnowledgeBase(String file, boolean newKB) throws KnowledgeBaseException {
        if (newKB) {
            CurrentProject.getInstance().newProyect(".", "KnwoledgeBase.sqlite");
        } else {
            CurrentProject.getInstance().loadProyect("KnwoledgeBase.sqlite");
        }
        this.kbm = CurrentProject.getInstance().getKnowledgeBase();
        this.affiliationDAO = new AffiliationDAO(this.kbm);
        this.authorAffiliationDAO = new AuthorAffiliationDAO(this.kbm);
        this.authorDAO = new AuthorDAO(this.kbm);
        this.authorGroupDAO = new AuthorGroupDAO(this.kbm);
        this.authorReferenceDAO = new AuthorReferenceDAO(this.kbm);
        this.authorReferenceGroupDAO = new AuthorReferenceGroupDAO(this.kbm);
        this.authorReferenceReferenceDAO = new AuthorReferenceReferenceDAO(this.kbm);
        this.documentAffiliationDAO = new DocumentAffiliationDAO(this.kbm);
        this.documentAuthorDAO = new DocumentAuthorDAO(this.kbm);
        this.documentDAO = new DocumentDAO(this.kbm);
        this.documentReferenceDAO = new DocumentReferenceDAO(this.kbm);
        this.documentWordDAO = new DocumentWordDAO(this.kbm);
        this.journalDAO = new JournalDAO(this.kbm);
        this.journalSubjectCategoryPublishDateDAO = new JournalSubjectCategoryPublishDateDAO(this.kbm);
        this.publishDateDAO = new PublishDateDAO(this.kbm);
        this.publishDatePeriodDAO = new PublishDatePeriodDAO(this.kbm);
        this.periodDAO = new PeriodDAO(this.kbm);
        this.referenceDAO = new ReferenceDAO(this.kbm);
        this.referenceGroupDAO = new ReferenceGroupDAO(this.kbm);
        this.referenceSourceDAO = new ReferenceSourceDAO(this.kbm);
        this.referenceSourceGroupDAO = new ReferenceSourceGroupDAO(this.kbm);
        this.subjectCategoryDAO = new SubjectCategoryDAO(this.kbm);
        this.wordDAO = new WordDAO(this.kbm);
        this.wordGroupDAO = new WordGroupDAO(this.kbm);
    }

    private void add() throws KnowledgeBaseException {
        this.addAffiliation();
        this.addAuthor();
        this.addAuthorGroup();
        this.addAuthorReference();
        this.addAuthorReferenceGroup();
        this.addDocument();
        this.addJournal();
        this.addPeriod();
        this.addPublishDate();
        this.addReference();
        this.addReferenceGroup();
        this.addRefenceSource();
        this.addReferenceSourceGroup();
        this.addSubjectCategory();
        this.addWord();
        this.addWordGroup();
    }

    private void addAffiliation() throws KnowledgeBaseException {
        System.out.println("Adding affiliations...");
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation1", false));
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation2", false));
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation3", false));
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation4", false));
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation5", false));
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation6", false));
        System.out.println("Affiliation ID: " + this.affiliationDAO.addAffiliation("Affiliation7", false));
    }

    private void addAuthor() throws KnowledgeBaseException {
        System.out.println("Adding authors...");
        System.out.println("Author ID: " + this.authorDAO.addAuthor("Author 1", "Full name author 1", false));
        System.out.println("Author ID: " + this.authorDAO.addAuthor("Author 2", "Full name author 2", false));
        System.out.println("Author ID: " + this.authorDAO.addAuthor("Author 3", "Full name author 3", false));
        System.out.println("Author ID: " + this.authorDAO.addAuthor("Author 4", "Full name author 4", false));
        System.out.println("Author ID: " + this.authorDAO.addAuthor("Author 5", "Full name author 5", false));
        System.out.println("Author ID: " + this.authorDAO.addAuthor("Author 6", "Full name author 6", false));
    }

    private void addAuthorGroup() throws KnowledgeBaseException {
        System.out.println("Adding author groups...");
        System.out.println("AuhtorGroups ID: " + this.authorGroupDAO.addAuthorGroup("AuthorGroup1", false, false));
        System.out.println("AuthorGroups ID: " + this.authorGroupDAO.addAuthorGroup("AuthorGroup2", true, false));
        System.out.println("AuhtorGroups ID: " + this.authorGroupDAO.addAuthorGroup("AuthorGroup3", false, false));
    }

    private void addAuthorReference() throws KnowledgeBaseException {
        System.out.println("Adding author references...");
        System.out.println("AuthorReference ID: " + this.authorReferenceDAO.addAuthorReference("AuthorReference1", false));
        System.out.println("AuthorReference ID: " + this.authorReferenceDAO.addAuthorReference("AuthorReference2", false));
        System.out.println("AuthorReference ID: " + this.authorReferenceDAO.addAuthorReference("AuthorReference3", false));
        System.out.println("AuthorReference ID: " + this.authorReferenceDAO.addAuthorReference("AuthorReference4", false));
        System.out.println("AuthorReference ID: " + this.authorReferenceDAO.addAuthorReference("AuthorReference5", false));
        System.out.println("AuthorReference ID: " + this.authorReferenceDAO.addAuthorReference("AuthorReference6", false));
    }

    private void addAuthorReferenceGroup() throws KnowledgeBaseException {
        System.out.println("Adding author reference groups...");
        System.out.println("AuthorReferenceGroups ID: " + this.authorReferenceGroupDAO.addAuthorReferenceGroup("AuthorReferenceGroup1", false, false));
        System.out.println("AuthorReferenceGroups ID: " + this.authorReferenceGroupDAO.addAuthorReferenceGroup("AuthorReferenceGroup2", true, false));
        System.out.println("AuthorReferenceGroups ID: " + this.authorReferenceGroupDAO.addAuthorReferenceGroup("AuthorReferenceGroup3", false, false));
    }

    private void addDocument() throws KnowledgeBaseException {
        System.out.println("Adding documents...");
        System.out.println("Document ID: " + this.documentDAO.addDocument("Title 1", "Abstarct1", "a", 0, null, "ISI1", false));
        System.out.println("Document ID: " + this.documentDAO.addDocument("Title 2", "Abstarct2", "a", 1, null, "ISI2", false));
        System.out.println("Document ID: " + this.documentDAO.addDocument("Title 3", "Abstarct3", "a", 100, "DOI:...", "ISI3", false));
        System.out.println("Document ID: " + this.documentDAO.addDocument("Title 4", "Abstarct4", "a", 25, null, "ISI4", false));
        System.out.println("Document ID: " + this.documentDAO.addDocument("Title 5", "Abstract 5", "c", 100, "DOI:xxx", "SCOPUS", "V1", "I1", "12", "23", false));
    }

    private void addJournal() throws KnowledgeBaseException {
        System.out.println("Adding journals...");
        System.out.println("Journal ID: " + this.journalDAO.addJournal("journal1", null, false));
        System.out.println("Journal ID: " + this.journalDAO.addJournal("journal2", "Conference", false));
    }

    private void addPeriod() throws KnowledgeBaseException {
        System.out.println("Adding periods...");
        System.out.println("Period ID: " + this.periodDAO.addPeriod("Period1", 1, false));
        System.out.println("Period ID: " + this.periodDAO.addPeriod("Period2", 2, false));
    }

    private void addPublishDate() throws KnowledgeBaseException {
        System.out.println("Adding publish dates...");
        System.out.println("PublishDate ID: " + this.publishDateDAO.addPublishDate("2000", "jan", false));
        System.out.println("PublishDate ID: " + this.publishDateDAO.addPublishDate("2005", "jan", false));
        System.out.println("PublishDate ID: " + this.publishDateDAO.addPublishDate("2005", "feb", false));
    }

    private void addReference() throws KnowledgeBaseException {
        System.out.println("Adding references...");
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference1", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference2", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference3", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference4", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference5", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference6", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference7", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference8", null, null, null, null, null, null, false));
        System.out.println("Reference ID: " + this.referenceDAO.addReference("Reference9", "V1", "I1", "pp. 150-170", "2007", "DOI:xxx", "ISI", false));
    }

    private void addReferenceGroup() throws KnowledgeBaseException {
        System.out.println("Adding reference groups...");
        System.out.println("ReferenceGroups ID: " + this.referenceGroupDAO.addReferenceGroup("ReferenceGroup1", false, false));
        System.out.println("ReferenceGroups ID: " + this.referenceGroupDAO.addReferenceGroup("ReferenceGroup2", true, false));
        System.out.println("ReferenceGroups ID: " + this.referenceGroupDAO.addReferenceGroup("ReferenceGroup3", false, false));
    }

    private void addRefenceSource() throws KnowledgeBaseException {
        System.out.println("Adding reference sources...");
        System.out.println("ReferenceSource ID: " + this.referenceSourceDAO.addReferenceSource("ReferenceSource1", false));
        System.out.println("ReferenceSource ID: " + this.referenceSourceDAO.addReferenceSource("ReferenceSource2", false));
    }

    private void addReferenceSourceGroup() throws KnowledgeBaseException {
        System.out.println("Adding reference source groups...");
        System.out.println("ReferenceSourceGroups ID: " + this.referenceSourceGroupDAO.addReferenceSourceGroup("ReferenceSourceGroup1", false, false));
        System.out.println("ReferenceSourceGroups ID: " + this.referenceSourceGroupDAO.addReferenceSourceGroup("ReferenceSourceGroup2", true, false));
        System.out.println("ReferenceSourceGroups ID: " + this.referenceSourceGroupDAO.addReferenceSourceGroup("ReferenceSourceGroup3", false, false));
    }

    private void addSubjectCategory() throws KnowledgeBaseException {
        System.out.println("Adding subject categories...");
        System.out.println("Subject Category ID: " + this.subjectCategoryDAO.addSubjectCategory("Category1", false));
        System.out.println("Subject Category ID: " + this.subjectCategoryDAO.addSubjectCategory("Category2", false));
    }

    private void addWord() throws KnowledgeBaseException {
        System.out.println("Adding words...");
        System.out.println("Word ID: " + this.wordDAO.addWord("Word1", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word2", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word3", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word4", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word5", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word6", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word7", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word8", false));
        System.out.println("Word ID: " + this.wordDAO.addWord("Word9", false));
    }

    private void addWordGroup() throws KnowledgeBaseException {
        System.out.println("Adding word groups...");
        System.out.println("WordGroups ID: " + this.wordGroupDAO.addWordGroup("WordGroup1", false, false));
        System.out.println("WordGroups ID: " + this.wordGroupDAO.addWordGroup("WordGroup2", true, false));
        System.out.println("WordGroups ID: " + this.wordGroupDAO.addWordGroup("WordGroup3", false, false));
    }

    private void remove() throws KnowledgeBaseException {
        this.removeAffiliation();
        this.removeAuthor();
        this.removeAuthorGroup();
        this.removeAuthorReference();
        this.removeAuthorReferenceGroup();
        this.removeDocument();
        this.removeJournal();
        this.removePeriod();
        this.removePublishDate();
        this.removeReference();
        this.removeReferenceGroup();
        this.removeRefenceSource();
        this.removeReferenceSourceGroup();
        this.removeSubjectCategory();
        this.removeWord();
        this.removeWordGroup();
    }

    private void removeAffiliation() throws KnowledgeBaseException {
        System.out.println("Removing affiliations...");
        System.out.println("Affiliation ID: " + this.affiliationDAO.removeAffiliation(1, false));
    }

    private void removeAuthor() throws KnowledgeBaseException {
        System.out.println("Removing authors...");
        System.out.println("Author ID: " + this.authorDAO.removeAuthor(1, false));
    }

    private void removeAuthorGroup() throws KnowledgeBaseException {
        System.out.println("Removing author groups...");
    }

    private void removeAuthorReference() throws KnowledgeBaseException {
        System.out.println("Removing author references...");
    }

    private void removeAuthorReferenceGroup() throws KnowledgeBaseException {
        System.out.println("Removing author reference groups...");
    }

    private void removeDocument() throws KnowledgeBaseException {
        System.out.println("Removing documents...");
    }

    private void removeJournal() throws KnowledgeBaseException {
        System.out.println("Removing journals...");
    }

    private void removePeriod() throws KnowledgeBaseException {
        System.out.println("Removing periods...");
    }

    private void removePublishDate() throws KnowledgeBaseException {
        System.out.println("Removing publish dates...");
    }

    private void removeReference() throws KnowledgeBaseException {
        System.out.println("Removing references...");
    }

    private void removeReferenceGroup() throws KnowledgeBaseException {
        System.out.println("Removing reference groups...");
    }

    private void removeRefenceSource() throws KnowledgeBaseException {
        System.out.println("Removing reference sources...");
    }

    private void removeReferenceSourceGroup() throws KnowledgeBaseException {
        System.out.println("Removing reference source groups...");
    }

    private void removeSubjectCategory() throws KnowledgeBaseException {
        System.out.println("Removing subject categories...");
    }

    private void removeWord() throws KnowledgeBaseException {
        System.out.println("Removing words...");
    }

    private void removeWordGroup() throws KnowledgeBaseException {
        System.out.println("Removing word groups...");
    }

    private void singelSelect() throws KnowledgeBaseException {
        System.out.println("Selecting one item....");
        System.out.println(this.affiliationDAO.getAffiliation(1));
        System.out.println(this.authorDAO.getAuthor(1));
        System.out.println(this.authorGroupDAO.getAuthorGroup(1));
        System.out.println(this.authorReferenceDAO.getAuthorReference(1));
        System.out.println(this.authorReferenceGroupDAO.getAuthorReferenceGroup(1));
        System.out.println(this.documentDAO.getDocument(1));
        System.out.println(this.journalDAO.getJournal(1));
        System.out.println(this.periodDAO.getPeriod(1));
        System.out.println(this.publishDateDAO.getPublishDate(1));
        System.out.println(this.referenceDAO.getReference(1));
        System.out.println(this.referenceGroupDAO.getReferenceGroup(1));
        System.out.println(this.referenceSourceDAO.getReferenceSource(1));
        System.out.println(this.referenceSourceGroupDAO.getReferenceSourceGroup(1));
        System.out.println(this.subjectCategoryDAO.getSubjectCategory(1));
        System.out.println(this.wordDAO.getWord(1));
        System.out.println(this.wordGroupDAO.getWordGroup(1));
    }

    private void selectAllItems() throws KnowledgeBaseException {
        System.out.println("Selecting all items....");
        System.out.println(this.affiliationDAO.getAffiliations());
        System.out.println(this.authorDAO.getAuthors());
        System.out.println(this.authorGroupDAO.getAuthorGroups());
        System.out.println(this.authorGroupDAO.getAuthorGroups(true));
        System.out.println(this.authorGroupDAO.getAuthorGroups(false));
        System.out.println(this.authorReferenceDAO.getAuthorReferences());
        System.out.println(this.authorReferenceGroupDAO.getAuthorReferenceGroups());
        System.out.println(this.authorReferenceGroupDAO.getAuthorReferenceGroups(true));
        System.out.println(this.authorReferenceGroupDAO.getAuthorReferenceGroups(false));
        System.out.println(this.documentDAO.getDocuments());
        System.out.println(this.journalDAO.getJournals());
        System.out.println(this.periodDAO.getPeriods());
        System.out.println(this.publishDateDAO.getPublishDates());
        System.out.println(this.referenceDAO.getReferences());
        System.out.println(this.referenceGroupDAO.getReferenceGroups());
        System.out.println(this.referenceGroupDAO.getReferenceGroups(true));
        System.out.println(this.referenceGroupDAO.getReferenceGroups(false));
        System.out.println(this.referenceSourceDAO.getReferenceSources());
        System.out.println(this.referenceSourceGroupDAO.getReferenceSourceGroups());
        System.out.println(this.referenceSourceGroupDAO.getReferenceSourceGroups(true));
        System.out.println(this.referenceSourceGroupDAO.getReferenceSourceGroups(false));
        System.out.println(this.subjectCategoryDAO.getSubjectCategories());
        System.out.println(this.wordDAO.getWords());
        System.out.println(this.wordGroupDAO.getWordGroups());
        System.out.println(this.wordGroupDAO.getWordGroups(true));
        System.out.println(this.wordGroupDAO.getWordGroups(false));
    }

    private void update() throws KnowledgeBaseException {
        this.updateAffiliation();
        this.updateAuthor();
        this.updateAuthorGroup();
        this.updateAuthorReference();
        this.updateAuthorReferenceGroup();
        this.updateDocument();
        this.updateJournal();
        this.updatePeriod();
        this.updatePublishDate();
        this.updateReference();
        this.updateReferenceGroup();
        this.updateRefenceSource();
        this.updateReferenceSourceGroup();
        this.updateSubjectCategory();
        this.updateWord();
        this.updateWordGroup();
    }

    private void updateAffiliation() throws KnowledgeBaseException {
        System.out.println("Updating affiliations...");
        System.out.println("Update: " + this.affiliationDAO.setFullAffiliation(1, "Affiliation updated", false));
        System.out.println("Update: " + this.affiliationDAO.getAffiliation(1));
    }

    private void updateAuthor() throws KnowledgeBaseException {
        System.out.println("Updating authors...");
        System.out.println("Update: " + this.authorDAO.setAuthorName(1, "Name updated", false));
        System.out.println("Update: " + this.authorDAO.setFullAuthorName(1, "Full name updated", false));
    }

    private void updateAuthorGroup() throws KnowledgeBaseException {
        System.out.println("Updating author groups...");
        System.out.println("Update: ");
        System.out.println("Update: " + this.authorGroupDAO.setGroupName(1, "Group name updated", false));
        System.out.println("Update: " + this.authorGroupDAO.setStopGroup(1, true, false));
    }

    private void updateAuthorReference() throws KnowledgeBaseException {
        System.out.println("Updating author references...");
        System.out.println("Update: " + this.authorReferenceDAO.setAuthorName(1, "Author name updated", false));
    }

    private void updateAuthorReferenceGroup() throws KnowledgeBaseException {
        System.out.println("Updating author reference groups...");
        System.out.println("Update: " + this.authorReferenceGroupDAO.setGroupName(1, "Group name updated", false));
        System.out.println("Update: " + this.authorReferenceGroupDAO.setStopGroup(1, true, false));
    }

    private void updateDocument() throws KnowledgeBaseException {
        System.out.println("Updating documents...");
        System.out.println("Update: " + this.documentDAO.setTitle(1, "Title updated", false));
        System.out.println("Update: " + this.documentDAO.setType(1, "Type updated", false));
        System.out.println("Update: " + this.documentDAO.setDocAbstract(1, "Abstract updated", false));
        System.out.println("Update: " + this.documentDAO.setCitationsCount(1, 5000, false));
        System.out.println("Update: " + this.documentDAO.setDoi(1, "DOI: updated", false));
        System.out.println("Update: " + this.documentDAO.setSourceIdentifier(1, "Source identifier updated", false));
        System.out.println("Update: " + this.documentDAO.setVolume(1, "V updated", false));
        System.out.println("Update: " + this.documentDAO.setIssue(1, "I updated", false));
        System.out.println("Update: " + this.documentDAO.setBeginPage(1, "begin page updated", false));
        System.out.println("Update: " + this.documentDAO.setEndPage(1, "end page updated", false));
    }

    private void updateJournal() throws KnowledgeBaseException {
        System.out.println("Updating journals...");
        System.out.println("Update: " + this.journalDAO.setSource(1, "source updated", false));
        System.out.println("Update: " + this.journalDAO.setConferenceInformation(1, "conference updated", false));
    }

    private void updatePeriod() throws KnowledgeBaseException {
        System.out.println("Updating periods...");
        System.out.println("Update: " + this.periodDAO.setName(1, "peiod name updated", false));
    }

    private void updatePublishDate() throws KnowledgeBaseException {
        System.out.println("Updating publish dates...");
        System.out.println("Update: " + this.publishDateDAO.setYear(1, "1900", false));
        System.out.println("Update: " + this.publishDateDAO.setDate(1, "date updated", false));
    }

    private void updateReference() throws KnowledgeBaseException {
        System.out.println("Updating references...");
        System.out.println("Update: " + this.referenceDAO.setFullReference(1, "Full reference updated", false));
        System.out.println("Update: " + this.referenceDAO.setVolume(1, "V updated", false));
        System.out.println("Update: " + this.referenceDAO.setIssue(1, "I updated", false));
        System.out.println("Update: " + this.referenceDAO.setPage(1, "page updated", false));
        System.out.println("Update: " + this.referenceDAO.setDoi(1, "DOI updated", false));
        System.out.println("Update: " + this.referenceDAO.setFormat(1, "Format updated", false));
        System.out.println("Update: " + this.referenceDAO.setYear(1, "1900", false));
    }

    private void updateReferenceGroup() throws KnowledgeBaseException {
        System.out.println("Updating reference groups...");
        System.out.println("Update: " + this.referenceGroupDAO.setGroupName(1, "group name updated", false));
        System.out.println("Update: " + this.referenceGroupDAO.setStopGroup(1, true, false));
    }

    private void updateRefenceSource() throws KnowledgeBaseException {
        System.out.println("Updating reference sources...");
        System.out.println("Update: " + this.referenceSourceDAO.setSource(1, "Source updated", false));
    }

    private void updateReferenceSourceGroup() throws KnowledgeBaseException {
        System.out.println("Updating reference source groups...");
        System.out.println("Update: " + this.referenceSourceGroupDAO.setGroupName(1, "group name updated", false));
        System.out.println("Update: " + this.referenceSourceGroupDAO.setStopGroup(1, true, false));
    }

    private void updateSubjectCategory() throws KnowledgeBaseException {
        System.out.println("Updating subject categories...");
        System.out.println("Update: " + this.subjectCategoryDAO.setSubjectCategoryName(1, "Name changed", false));
    }

    private void updateWord() throws KnowledgeBaseException {
        System.out.println("Updating words...");
        System.out.println("Update: " + this.wordDAO.setWordName(1, "Name changed", false));
    }

    private void updateWordGroup() throws KnowledgeBaseException {
        System.out.println("Updating word groups...");
        System.out.println("Update: " + this.wordGroupDAO.setGroupName(1, "group name updated", false));
        System.out.println("Update: " + this.wordGroupDAO.setStopGroup(1, true, false));
    }

    private void relations() throws KnowledgeBaseException {
        System.out.println(this.documentDAO.setPublishDate(1, 1, false));
        System.out.println(this.documentDAO.setJournal(1, 1, false));
        System.out.println(this.documentAffiliationDAO.addDocumentAffiliation(1, 1, false));
        System.out.println(this.documentAffiliationDAO.addDocumentAffiliation(1, 2, false));
        System.out.println(this.documentAffiliationDAO.addDocumentAffiliation(3, 3, false));
        System.out.println(this.documentAffiliationDAO.addDocumentAffiliation(4, 1, false));
        System.out.println(this.documentAffiliationDAO.addDocumentAffiliation(2, 4, false));
        System.out.println(this.authorAffiliationDAO.addAuthorAffiliation(1, 1, false));
        System.out.println(this.authorAffiliationDAO.addAuthorAffiliation(1, 2, false));
        System.out.println(this.authorAffiliationDAO.addAuthorAffiliation(1, 3, false));
        System.out.println(this.authorAffiliationDAO.addAuthorAffiliation(2, 3, false));
        System.out.println(this.authorAffiliationDAO.addAuthorAffiliation(2, 4, false));
        System.out.println(this.wordDAO.setWordGroup(1, 1, false));
        System.out.println(this.documentAuthorDAO.addDocumentAuthor(1, 1, 1, false));
        System.out.println(this.documentAuthorDAO.addDocumentAuthor(1, 2, 2, false));
        System.out.println(this.documentAuthorDAO.addDocumentAuthor(2, 3, 1, false));
        System.out.println(this.documentAuthorDAO.addDocumentAuthor(2, 4, 2, false));
    }

    public static void main(String[] args) {
        try {
            new AppTestKB().execute();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.out.println("End.");
    }
}

