/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.util.ArrayList;
import scimat.api.analysis.network.labeller.BasicClusterLabellerBasedOnMainNode;
import scimat.api.analysis.network.labeller.BasicNodeLabeller;
import scimat.api.analysis.network.labeller.ClusterSetLabelSetter;
import scimat.api.analysis.network.labeller.NodeLabelSetter;
import scimat.api.analysis.network.statistics.CalculateNormalizedRange;
import scimat.api.analysis.network.statistics.CallonCentrality;
import scimat.api.analysis.network.statistics.CallonDensity;
import scimat.api.analysis.network.statistics.ClusterSetNetworkMeasureSetter;
import scimat.api.analysis.performance.ClusterSetAggregationDocumentsMeasureSetter;
import scimat.api.analysis.performance.docmapper.ClusterSetDocumentsSetter;
import scimat.api.analysis.performance.docmapper.CoreDocumentMapper;
import scimat.api.analysis.performance.docmapper.SecondaryDocumentMapper;
import scimat.api.analysis.performance.quality.HIndex;
import scimat.api.analysis.performance.quality.SumCitationAggregationMeasure;
import scimat.api.analysis.performance.quantity.DocumentCountAggregationMeasure;
import scimat.api.analysis.temporal.EvolutionMap;
import scimat.api.analysis.temporal.EvolutionMapBuilder;
import scimat.api.analysis.temporal.OverlappingMap;
import scimat.api.analysis.temporal.OverlappingMapBuilder;
import scimat.api.analysis.temporal.OverlappingMeasure;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnWordsBuilder;
import scimat.api.dataset.networkbuilder.NetworkCoOccurrenceBuilder;
import scimat.api.mapping.clustering.CentersSimpleGroupingAlgorithm;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.preprocessing.reduction.data.FilterItemByFrequency;
import scimat.api.preprocessing.reduction.network.FilterByEdgeValue;
import scimat.api.similaritymeasure.CoOccurrenceNormalizer;
import scimat.api.similaritymeasure.direct.EquivalenceIndexMeasure;
import scimat.api.similaritymeasure.direct.InclusionIndexMeasure;
import scimat.api.similaritymeasure.direct.JaccardIndexMeasure;
import scimat.model.knowledgebase.entity.Period;
import scimat.project.CurrentProject;

public class AnaylsisApp {
    public static void main(String[] args) {
        try {
            int i;
            CurrentProject.getInstance().loadProyect("FSSandIEEETFS.sqlite");
            ArrayList<Period> periods = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriodsOrderedByPosition();
            DatasetBasedOnWordsBuilder datasetBuilder = new DatasetBasedOnWordsBuilder(CurrentProject.getInstance().getKnowledgeBase(), true, false, false);
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            for (i = 0; i < periods.size(); ++i) {
                Period period = periods.get(i);
                datasets.add(datasetBuilder.execute(CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPublishDates(period.getPeriodID())));
            }
            FilterItemByFrequency frequencyFilter = new FilterItemByFrequency(3);
            frequencyFilter.execute((Dataset)datasets.get(0));
            frequencyFilter = new FilterItemByFrequency(4);
            frequencyFilter.execute((Dataset)datasets.get(1));
            frequencyFilter = new FilterItemByFrequency(4);
            frequencyFilter.execute((Dataset)datasets.get(2));
            frequencyFilter = new FilterItemByFrequency(4);
            frequencyFilter.execute((Dataset)datasets.get(3));
            frequencyFilter = new FilterItemByFrequency(5);
            frequencyFilter.execute((Dataset)datasets.get(4));
            UndirectNetworkMatrix[] networks = new UndirectNetworkMatrix[datasets.size()];
            NetworkCoOccurrenceBuilder networkBuilder = new NetworkCoOccurrenceBuilder((Dataset)datasets.get(0));
            networks[0] = networkBuilder.execute();
            networkBuilder = new NetworkCoOccurrenceBuilder((Dataset)datasets.get(1));
            networks[1] = networkBuilder.execute();
            networkBuilder = new NetworkCoOccurrenceBuilder((Dataset)datasets.get(2));
            networks[2] = networkBuilder.execute();
            networkBuilder = new NetworkCoOccurrenceBuilder((Dataset)datasets.get(3));
            networks[3] = networkBuilder.execute();
            networkBuilder = new NetworkCoOccurrenceBuilder((Dataset)datasets.get(4));
            networks[4] = networkBuilder.execute();
            FilterByEdgeValue coOccurrenceFilter = new FilterByEdgeValue(2.0);
            coOccurrenceFilter.execute(networks[0]);
            coOccurrenceFilter = new FilterByEdgeValue(3.0);
            coOccurrenceFilter.execute(networks[1]);
            coOccurrenceFilter = new FilterByEdgeValue(3.0);
            coOccurrenceFilter.execute(networks[2]);
            coOccurrenceFilter = new FilterByEdgeValue(3.0);
            coOccurrenceFilter.execute(networks[3]);
            coOccurrenceFilter = new FilterByEdgeValue(4.0);
            coOccurrenceFilter.execute(networks[4]);
            CoOccurrenceNormalizer normalizer = new CoOccurrenceNormalizer(new EquivalenceIndexMeasure());
            for (i = 0; i < datasets.size(); ++i) {
                normalizer.execute((Dataset)datasets.get(i), networks[i]);
            }
            CentersSimpleGroupingAlgorithm clusterAlgorithm = new CentersSimpleGroupingAlgorithm(3, 12);
            ArrayList<ClusterSet> clusterSets = new ArrayList<ClusterSet>();
            for (i = 0; i < networks.length; ++i) {
                clusterSets.add(clusterAlgorithm.execute(networks[i]));
            }
            for (i = 0; i < clusterSets.size(); ++i) {
                NodeLabelSetter nodeLabelAssigner = new NodeLabelSetter(new BasicNodeLabeller((Dataset)datasets.get(i)));
                nodeLabelAssigner.execute(((ClusterSet)clusterSets.get(i)).getWholeNetwork().getNodes(), "name");
            }
            for (i = 0; i < clusterSets.size(); ++i) {
                ClusterSetLabelSetter clusterSetLabelAssigner = new ClusterSetLabelSetter(new BasicClusterLabellerBasedOnMainNode((Dataset)datasets.get(i)));
                clusterSetLabelAssigner.execute((ClusterSet)clusterSets.get(i), "name");
            }
            ClusterSetNetworkMeasureSetter clusterSetNetworkMeasureSetter = new ClusterSetNetworkMeasureSetter(new CallonCentrality());
            clusterSetNetworkMeasureSetter = new ClusterSetNetworkMeasureSetter(new CallonDensity());
            CalculateNormalizedRange calculateNormalizedRange = new CalculateNormalizedRange();
            for (i = 0; i < clusterSets.size(); ++i) {
                clusterSetNetworkMeasureSetter.execute((ClusterSet)clusterSets.get(i), "callonCentrality");
                clusterSetNetworkMeasureSetter.execute((ClusterSet)clusterSets.get(i), "callonDensity");
                calculateNormalizedRange.calculateMeasures((ClusterSet)clusterSets.get(i), "callonCentrality", "callonCentralityRange");
                calculateNormalizedRange.calculateMeasures(clusterSets.get(i), "callonDensity", "callonDensityRange");
            }
            for (i = 0; i < clusterSets.size(); ++i) {
                ClusterSetDocumentsSetter clusterSetDocumentsSetter = new ClusterSetDocumentsSetter(new CoreDocumentMapper(((ClusterSet)clusterSets.get(i)).getWholeNetwork(), (Dataset)datasets.get(i)));
                clusterSetDocumentsSetter.execute(clusterSets.get(i), "coreDocuments");
                clusterSetDocumentsSetter = new ClusterSetDocumentsSetter(new SecondaryDocumentMapper((Dataset)datasets.get(i)));
                clusterSetDocumentsSetter.execute(clusterSets.get(i), "secondaryDocuments");
            }
            for (i = 0; i < clusterSets.size(); ++i) {
                ClusterSetAggregationDocumentsMeasureSetter clusterSetAggregationDocumentsMeasureSetter = new ClusterSetAggregationDocumentsMeasureSetter(new DocumentCountAggregationMeasure());
                clusterSetAggregationDocumentsMeasureSetter.execute((ClusterSet)clusterSets.get(i), "coreDocuments", "coreDocumentsCount");
                clusterSetAggregationDocumentsMeasureSetter.execute(clusterSets.get(i), "secondaryDocuments", "secondaryDocumentsCount");
                clusterSetAggregationDocumentsMeasureSetter = new ClusterSetAggregationDocumentsMeasureSetter(new SumCitationAggregationMeasure(datasets.get(i)));
                clusterSetAggregationDocumentsMeasureSetter.execute(clusterSets.get(i), "coreDocuments", "coreDocumentsCitations");
                clusterSetAggregationDocumentsMeasureSetter.execute(clusterSets.get(i), "secondaryDocuments", "secondaryDocumentsCitations");
                clusterSetAggregationDocumentsMeasureSetter = new ClusterSetAggregationDocumentsMeasureSetter(new HIndex(datasets.get(i)));
                clusterSetAggregationDocumentsMeasureSetter.execute(clusterSets.get(i), "coreDocuments", "coreDocumentsH-Index");
                clusterSetAggregationDocumentsMeasureSetter.execute(clusterSets.get(i), "secondaryDocuments", "secondaryDocumentsH-Index");
            }
            EvolutionMapBuilder evolutionMapBuilder = new EvolutionMapBuilder(new OverlappingMeasure(new InclusionIndexMeasure()));
            EvolutionMap evolutionMap = evolutionMapBuilder.buildEvolutionMap(clusterSets);
            OverlappingMapBuilder overlappingMapBuilder = new OverlappingMapBuilder(new OverlappingMeasure(new JaccardIndexMeasure()));
            OverlappingMap overlappingMap = overlappingMapBuilder.buildOverlappingMap(datasets);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

