/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.util.ArrayList;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class AddWordsFromTitleAutomaticWay {
    private int minWordsThreshold;

    public AddWordsFromTitleAutomaticWay(int minWordsThreshold) {
        this.minWordsThreshold = minWordsThreshold;
    }

    public void execute() throws KnowledgeBaseException {
        KnowledgeBaseManager kbm = new KnowledgeBaseManager();
        kbm.loadKnowledgeBase("proyecto", true);
        DocumentDAO documentDAO = new DocumentDAO(kbm);
        WordDAO wordDAO = new WordDAO(kbm);
        DocumentWordDAO documentWordDAO = new DocumentWordDAO(kbm);
        ArrayList<Document> documents = documentDAO.getDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            Document document = documents.get(i);
            System.out.println("Document ID: " + document.getDocumentID());
            String title = document.getTitle().toUpperCase();
            title = title.replaceAll("\\(", " ");
            title = title.replaceAll("\\)", " ");
            title = title.replaceAll("\\.", " ");
            title = title.replaceAll(",", " ");
            title = title.replaceAll(":", " ");
            title = title.replaceAll(";", " ");
            title = title.replaceAll(" - ", " ");
            title = title.replaceAll("[ ]+", " ");
            String[] titleTerms = title.split(" ");
            for (int j = 0; j < titleTerms.length; ++j) {
                Word word = wordDAO.getWord(titleTerms[j]);
                if (word == null) {
                    Integer wordID = wordDAO.addWord(titleTerms[j], false);
                    word = wordDAO.getWord(wordID);
                }
                if (!documentWordDAO.checkDocumentWord(document.getDocumentID(), word.getWordID())) {
                    documentWordDAO.addDocumentWord(document.getDocumentID(), word.getWordID(), false, false, true, false);
                    continue;
                }
                documentWordDAO.setAddedKeyword(document.getDocumentID(), word.getWordID(), true, false);
            }
        }
        kbm.commit();
        kbm.close();
    }

    public static void main(String[] args) {
        try {
            new AddWordsFromTitleAutomaticWay(1).execute();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

