/*
 * Decompiled with CFR 0.152.
 */
package scimat.apps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class AddWordsFromAbstractAutomaticWay {
    private int minWordsThreshold;

    public AddWordsFromAbstractAutomaticWay(int minWordsThreshold) {
        this.minWordsThreshold = minWordsThreshold;
    }

    public void execute() throws KnowledgeBaseException {
        KnowledgeBaseManager kbm = new KnowledgeBaseManager();
        kbm.loadKnowledgeBase("proyecto", true);
        DocumentDAO documentDAO = new DocumentDAO(kbm);
        WordDAO wordDAO = new WordDAO(kbm);
        DocumentWordDAO documentWordDAO = new DocumentWordDAO(kbm);
        ArrayList<Word> words = wordDAO.getWords();
        Collections.sort(words, new Comparator<Word>(){

            @Override
            public int compare(Word o1, Word o2) {
                if (o1.getWordName().length() < o2.getWordName().length()) {
                    return 1;
                }
                if (o1.getWordName().length() > o2.getWordName().length()) {
                    return -1;
                }
                return o1.getWordName().compareTo(o2.getWordName());
            }
        });
        ArrayList<Document> documents = documentDAO.getDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            Document document = documents.get(i);
            System.out.print(document.getDocumentID() + "-->");
            String abstractText = document.getDocAbstract();
            if (abstractText != null) {
                abstractText = "-" + document.getDocAbstract().trim().toUpperCase().replaceAll("[ ]+", "-") + "-";
                for (int j = 0; j < words.size(); ++j) {
                    Word word = words.get(j);
                    String keywordName = "-" + word.getWordName() + "-";
                    if (!abstractText.contains(keywordName)) continue;
                    abstractText = abstractText.replace(word.getWordName(), "");
                    System.out.print(word.getWordName() + ",");
                    if (!documentWordDAO.checkDocumentWord(document.getDocumentID(), word.getWordID())) {
                        documentWordDAO.addDocumentWord(document.getDocumentID(), word.getWordID(), false, false, true, false);
                        continue;
                    }
                    documentWordDAO.setAddedKeyword(document.getDocumentID(), word.getWordID(), true, false);
                }
            }
            System.out.println();
        }
        kbm.commit();
        kbm.close();
    }

    public static void main(String[] args) {
        try {
            new AddWordsFromAbstractAutomaticWay(1).execute();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

