/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.visualization.temporal;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import scimat.api.analysis.temporal.OverlappingMap;

public class OverlappingMapSVG {
    private int sphereRadius;
    private int gapBetweenSpheres;
    private int arrowLength;
    private int textPx;
    private NumberFormat numberFormatter = new DecimalFormat(",##0.##");

    public OverlappingMapSVG(int sphereRadius, int gapBetweenSpheres, int arrowLength, int textPx) {
        this.sphereRadius = sphereRadius;
        this.gapBetweenSpheres = gapBetweenSpheres;
        this.arrowLength = arrowLength;
        this.textPx = textPx;
    }

    public Document buildXML(OverlappingMap overlappingMap) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        int width = this.sphereRadius * 2 * overlappingMap.getPeriodCount() + this.gapBetweenSpheres * (overlappingMap.getPeriodCount() - 1);
        int height = this.sphereRadius * 2 + this.arrowLength;
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf(width));
        svgRoot.setAttributeNS(null, "height", String.valueOf(height));
        svgRoot.setAttributeNS(null, "viewBox", "0 0 " + width + " " + height);
        this.addDefs(doc, svgNS, svgRoot);
        int sphereY = this.sphereRadius + this.arrowLength;
        if (overlappingMap.getPeriodCount() > 0) {
            int sphereLastX = this.calculateSphereX(0);
            this.drawSpheres(sphereLastX, sphereY, doc, svgNS, svgRoot);
            this.drawSphereText(sphereLastX, sphereY, overlappingMap.getItemsCountInPeriod(0), doc, svgNS, svgRoot);
            for (int i = 1; i < overlappingMap.getPeriodCount(); ++i) {
                this.drawUpArrow(sphereLastX, doc, svgNS, svgRoot);
                this.drawUpArrowText(sphereLastX, overlappingMap.getDissapearedItemsCountInPeriod(i - 1), doc, svgNS, svgRoot);
                int sphereX = this.calculateSphereX(i);
                this.drawSpheres(sphereX, sphereY, doc, svgNS, svgRoot);
                this.drawSphereText(sphereX, sphereY, overlappingMap.getItemsCountInPeriod(i), doc, svgNS, svgRoot);
                this.drawDownArrow(sphereX, doc, svgNS, svgRoot);
                this.drawDownArrowText(sphereX, overlappingMap.getNewItemsCountInPeriod(i), doc, svgNS, svgRoot);
                this.drawHorizontalArrow(sphereLastX, sphereX, sphereY, doc, svgNS, svgRoot);
                this.drawHorizontalArrowText(sphereLastX, sphereY, overlappingMap.getOverlappedItemsCountInPeriod(i - 1), overlappingMap.getOverlappingWeight(i - 1), doc, svgNS, svgRoot);
                sphereLastX = sphereX;
            }
        }
        return doc;
    }

    private void addDefs(Document doc, String svgNS, Element element) {
        Element defs = doc.createElementNS(svgNS, "defs");
        defs.setAttribute("id", "defs4");
        Element market = doc.createElementNS(svgNS, "marker");
        market.setAttributeNS(null, "refX", "0");
        market.setAttributeNS(null, "refY", "0");
        market.setAttributeNS(null, "orient", "auto");
        market.setAttributeNS(null, "id", "TriangleOutL");
        market.setAttributeNS(null, "style", "overflow:visible");
        Element path = doc.createElementNS(svgNS, "path");
        path.setAttributeNS(null, "d", "M 5.77,0 L -2.88,5 L -2.88,-5 L 5.77,0 z");
        path.setAttributeNS(null, "transform", "scale(0.8,0.8)");
        path.setAttributeNS(null, "style", "fill-rule:evenodd;stroke:#000000;stroke-width:1pt;marker-start:none");
        market.appendChild(path);
        market.appendChild(path);
        defs.appendChild(market);
        element.appendChild(defs);
    }

    private void drawSpheres(int x, int y, Document doc, String svgNS, Element element) {
        Element subElement = doc.createElementNS(svgNS, "circle");
        subElement.setAttributeNS(null, "cx", String.valueOf(x));
        subElement.setAttributeNS(null, "cy", String.valueOf(y));
        subElement.setAttributeNS(null, "r", String.valueOf(this.sphereRadius));
        subElement.setAttributeNS(null, "fill", "#FFFFFF");
        subElement.setAttributeNS(null, "stroke", "#000000");
        element.appendChild(subElement);
    }

    private void drawUpArrow(int x, Document doc, String svgNS, Element element) {
        int x2 = x + this.arrowLength;
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(x));
        subElement.setAttributeNS(null, "y1", String.valueOf(this.sphereRadius));
        subElement.setAttributeNS(null, "x2", String.valueOf(x2));
        subElement.setAttributeNS(null, "y2", "0");
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        subElement.setAttributeNS(null, "style", "marker-end:url(#TriangleOutL)");
        element.appendChild(subElement);
    }

    private void drawDownArrow(int x, Document doc, String svgNS, Element element) {
        int x1 = x - this.arrowLength;
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(x1));
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", String.valueOf(x));
        subElement.setAttributeNS(null, "y2", String.valueOf(this.sphereRadius));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        subElement.setAttributeNS(null, "style", "marker-end:url(#TriangleOutL)");
        element.appendChild(subElement);
    }

    private void drawHorizontalArrow(int x1, int x2, int y, Document doc, String svgNS, Element element) {
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(x1 + this.sphereRadius));
        subElement.setAttributeNS(null, "y1", String.valueOf(y));
        subElement.setAttributeNS(null, "x2", String.valueOf(x2 - this.sphereRadius));
        subElement.setAttributeNS(null, "y2", String.valueOf(y));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        subElement.setAttributeNS(null, "style", "marker-end:url(#TriangleOutL)");
        element.appendChild(subElement);
    }

    private void drawUpArrowText(int sphereLastX, int dissapearingItems, Document doc, String svgNS, Element element) {
        int x = sphereLastX + this.arrowLength / 2;
        int y = this.arrowLength / 2;
        Element subElement = doc.createElementNS(svgNS, "text");
        subElement.setAttributeNS(null, "x", String.valueOf(x));
        subElement.setAttributeNS(null, "y", String.valueOf(y - 5));
        subElement.setAttributeNS(null, "text-anchor", "middle");
        subElement.setAttributeNS(null, "transform", "rotate(-45 " + x + " " + y + ")");
        subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;fill:#000000;font-family:Verdana");
        subElement.setTextContent(String.valueOf(dissapearingItems));
        element.appendChild(subElement);
    }

    private void drawDownArrowText(int sphereX, int newItems, Document doc, String svgNS, Element element) {
        int x = sphereX - this.arrowLength / 2;
        int y = this.arrowLength / 2;
        Element subElement = doc.createElementNS(svgNS, "text");
        subElement.setAttributeNS(null, "x", String.valueOf(x));
        subElement.setAttributeNS(null, "y", String.valueOf(y - 5));
        subElement.setAttributeNS(null, "text-anchor", "middle");
        subElement.setAttributeNS(null, "transform", "rotate(45 " + x + " " + y + ")");
        subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;fill:#000000;font-family:Verdana");
        subElement.setTextContent(String.valueOf(newItems));
        element.appendChild(subElement);
    }

    private void drawHorizontalArrowText(int sphereLastX, int y, int overlappedItems, double weight, Document doc, String svgNS, Element element) {
        Element subElement = doc.createElementNS(svgNS, "text");
        subElement.setAttributeNS(null, "x", String.valueOf(sphereLastX + this.sphereRadius + this.gapBetweenSpheres / 2));
        subElement.setAttributeNS(null, "y", String.valueOf(y - 5));
        subElement.setAttributeNS(null, "text-anchor", "middle");
        subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;fill:#000000;font-family:Verdana");
        subElement.setTextContent(overlappedItems + " (" + this.numberFormatter.format(weight) + ")");
        element.appendChild(subElement);
    }

    private void drawSphereText(int sphereX, int y, int items, Document doc, String svgNS, Element element) {
        Element subElement = doc.createElementNS(svgNS, "text");
        subElement.setAttributeNS(null, "x", String.valueOf(sphereX));
        subElement.setAttributeNS(null, "y", String.valueOf(y));
        subElement.setAttributeNS(null, "text-anchor", "middle");
        subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;fill:#000000;font-family:Verdana");
        subElement.setTextContent(String.valueOf(items));
        element.appendChild(subElement);
    }

    private int calculateSphereX(int period) {
        return this.sphereRadius + this.sphereRadius * 2 * period + this.gapBetweenSpheres * period;
    }
}

