/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.visualization.temporal;

import java.util.ArrayList;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import scimat.api.analysis.temporal.EvolutionMap;
import scimat.api.analysis.temporal.EvolutionMapNexus;
import scimat.api.mapping.clustering.result.ClusterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMapSVG {
    private int minRX;
    private int maxRX;
    private int horizontalGapBetweenSpheres;
    private int verticalGapBetweenSpheres;
    private int textPx;

    public EvolutionMapSVG(int minRX, int maxRX, int horizontalGapBetweenSpheres, int verticalGapBetweenSpheres, int textPx) {
        this.minRX = minRX;
        this.maxRX = maxRX;
        this.horizontalGapBetweenSpheres = horizontalGapBetweenSpheres;
        this.verticalGapBetweenSpheres = verticalGapBetweenSpheres;
        this.textPx = textPx;
    }

    public Document buildXML(ArrayList<ClusterSet> clusterSets, EvolutionMap evolutionMap, String volumePropertyName, String labelPropertyName) {
        int i;
        int maxClusterCount = 0;
        double maxClusterSize = 0.0;
        for (i = 0; i < clusterSets.size(); ++i) {
            ClusterSet clusterSet = clusterSets.get(i);
            if (clusterSet.getClustersCount() > maxClusterCount) {
                maxClusterCount = clusterSet.getClustersCount();
            }
            if (volumePropertyName == null) continue;
            for (int j = 0; j < clusterSet.getClustersCount(); ++j) {
                double tmpValue = (Double)clusterSet.getCluster(j).getProperties().getProperty(volumePropertyName).getValue();
                if (!(tmpValue > maxClusterSize)) continue;
                maxClusterSize = tmpValue;
            }
        }
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        int width = this.maxRX * 2 * clusterSets.size() + this.horizontalGapBetweenSpheres * clusterSets.size();
        int height = this.maxRX * 2 * maxClusterCount + this.verticalGapBetweenSpheres * (maxClusterCount - 1);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf(width));
        svgRoot.setAttributeNS(null, "height", String.valueOf(height));
        this.addGradient(doc, svgNS, svgRoot);
        if (clusterSets.size() > 0) {
            double[][] lastCoords = this.drawCluster(clusterSets.get(0), 0, maxClusterSize, volumePropertyName, labelPropertyName, height, doc, svgNS, svgRoot);
            for (i = 1; i < clusterSets.size(); ++i) {
                double[][] currentCoords = this.drawCluster(clusterSets.get(i), i, maxClusterSize, volumePropertyName, labelPropertyName, height, doc, svgNS, svgRoot);
                this.drawNexus(lastCoords, currentCoords, i - 1, i, clusterSets, evolutionMap, doc, svgNS, svgRoot);
                lastCoords = currentCoords;
            }
        }
        return doc;
    }

    private void addGradient(Document doc, String svgNS, Element element) {
        Element radialGradient = doc.createElementNS(svgNS, "radialGradient");
        radialGradient.setAttributeNS(null, "id", "sphereTheme");
        Element stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0");
        stop.setAttributeNS(null, "style", "stop-color:#C6DD3A");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.211");
        stop.setAttributeNS(null, "style", "stop-color:#C3DA39");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.3881");
        stop.setAttributeNS(null, "style", "stop-color:#B8CF37");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.5529");
        stop.setAttributeNS(null, "style", "stop-color:#A7BE34");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.7103");
        stop.setAttributeNS(null, "style", "stop-color:#8EA630");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.861");
        stop.setAttributeNS(null, "style", "stop-color:#6F872A");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "1");
        stop.setAttributeNS(null, "style", "stop-color:#4B6323");
        radialGradient.appendChild(stop);
        element.appendChild(radialGradient);
    }

    private double[][] drawCluster(ClusterSet clusterSet, int period, double maxClusterSize, String volumePropertyName, String labelPropertyName, int height, Document doc, String svgNS, Element element) {
        double[][] coords = new double[clusterSet.getClustersCount()][3];
        int extraSupeiorGap = (height - (this.maxRX * 2 * clusterSet.getClustersCount() + this.verticalGapBetweenSpheres * (clusterSet.getClustersCount() - 1))) / 2;
        for (int i = 0; i < clusterSet.getClustersCount(); ++i) {
            double volume;
            int x = this.maxRX + this.maxRX * 2 * period + this.horizontalGapBetweenSpheres * period;
            int y = extraSupeiorGap + this.maxRX + this.maxRX * 2 * i + this.verticalGapBetweenSpheres * i;
            if (volumePropertyName == null || maxClusterSize == 0.0) {
                volume = this.maxRX;
            } else {
                volume = (Double)clusterSet.getCluster(i).getProperties().getProperty(volumePropertyName).getValue();
                volume = volume / maxClusterSize * (double)(this.maxRX - this.minRX) + (double)this.minRX;
            }
            coords[i][0] = x;
            coords[i][1] = y;
            coords[i][2] = volume;
            Element subElement = doc.createElementNS(svgNS, "circle");
            subElement.setAttributeNS(null, "cx", String.valueOf(x));
            subElement.setAttributeNS(null, "cy", String.valueOf(y));
            subElement.setAttributeNS(null, "r", String.valueOf(volume));
            subElement.setAttributeNS(null, "fill", "url(#sphereTheme)");
            element.appendChild(subElement);
            subElement = doc.createElementNS(svgNS, "text");
            subElement.setAttributeNS(null, "x", String.valueOf((double)x + volume));
            subElement.setAttributeNS(null, "y", String.valueOf(y));
            subElement.setAttributeNS(null, "id", "text23");
            subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;text-anchor:start;fill:#000000;font-family:Verdana");
            subElement.setTextContent((String)clusterSet.getCluster(i).getProperties().getProperty(labelPropertyName).getValue());
            element.appendChild(subElement);
        }
        return coords;
    }

    private void drawNexus(double[][] coordsPeriodI, double[][] coordsPeriodJ, int clusterSetI, int clusterSetJ, ArrayList<ClusterSet> clusterSets, EvolutionMap evolutionMap, Document doc, String svgNS, Element element) {
        int clusterCountI = clusterSets.get(clusterSetI).getClustersCount();
        int clusterCountJ = clusterSets.get(clusterSetJ).getClustersCount();
        for (int i = 0; i < clusterCountI; ++i) {
            double x1 = coordsPeriodI[i][0] + coordsPeriodI[i][2];
            double y1 = coordsPeriodI[i][1];
            for (int j = 0; j < clusterCountJ; ++j) {
                EvolutionMapNexus nexus = evolutionMap.getEvolutionNexus(clusterSetI, i, j);
                if (nexus == null) continue;
                this.drawArrow(x1, y1, coordsPeriodJ[j][0] - coordsPeriodJ[j][2], coordsPeriodJ[j][1], nexus.isShareMainNode(), doc, svgNS, element);
            }
        }
    }

    private void drawArrow(double x1, double y1, double x2, double y2, boolean solidLine, Document doc, String svgNS, Element element) {
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(x1));
        subElement.setAttributeNS(null, "y1", String.valueOf(y1));
        subElement.setAttributeNS(null, "x2", String.valueOf(x2));
        subElement.setAttributeNS(null, "y2", String.valueOf(y2));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        if (!solidLine) {
            subElement.setAttributeNS(null, "style", "stroke-dasharray: 9, 5");
        }
        element.appendChild(subElement);
    }
}

