/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.visualization.temporal;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.analysis.temporal.EvolutionMap;
import scimat.api.analysis.temporal.EvolutionMapNexus;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.utils.property.DoubleProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMapPajek {
    private ArrayList<ClusterSet> clusterSets;
    private EvolutionMap evolutionMap;
    private NumberFormat numberFormat = new DecimalFormat("0.0000");

    public EvolutionMapPajek(ArrayList<ClusterSet> clusterSets, EvolutionMap evolutionMap) {
        this.clusterSets = clusterSets;
        this.evolutionMap = evolutionMap;
    }

    public void execute(String path, String volumePropertyName, String labelPropertyName) throws FileNotFoundException {
        Cluster cluster;
        int clusterIndex;
        int periodIndex;
        PrintStream out = new PrintStream(path);
        ArrayList nodesIDs = new ArrayList();
        Integer id = 1;
        double maxSize = 0.0;
        for (periodIndex = 0; periodIndex < this.clusterSets.size(); ++periodIndex) {
            nodesIDs.add(new TreeMap());
            for (clusterIndex = 0; clusterIndex < this.clusterSets.get(periodIndex).getClustersCount(); ++clusterIndex) {
                cluster = this.clusterSets.get(periodIndex).getCluster(clusterIndex);
                double tmpSize = (Double)((DoubleProperty)cluster.getProperties().getProperty(volumePropertyName)).getValue();
                if (tmpSize > maxSize) {
                    maxSize = tmpSize;
                }
                if (((TreeMap)nodesIDs.get(periodIndex)).containsKey(cluster.getMainNode())) continue;
                ((TreeMap)nodesIDs.get(periodIndex)).put(cluster.getMainNode(), id);
                Integer n = id;
                Integer n2 = id = Integer.valueOf(id + 1);
            }
        }
        out.println("*Vertices " + (id - 1));
        for (periodIndex = 0; periodIndex < this.clusterSets.size(); ++periodIndex) {
            double coordY = 0.01;
            double coordX = 0.01 + 1.0 / (double)this.clusterSets.size() * (double)periodIndex;
            for (clusterIndex = 0; clusterIndex < this.clusterSets.get(periodIndex).getClustersCount(); ++clusterIndex) {
                cluster = this.clusterSets.get(periodIndex).getCluster(clusterIndex);
                out.print(((TreeMap)nodesIDs.get(periodIndex)).get(cluster.getMainNode()));
                out.print(" ");
                out.print("\"Per" + periodIndex + "_" + cluster.getProperties().getProperty(labelPropertyName).getValue() + "\"");
                out.print(" ");
                out.print(this.numberFormat.format(coordX));
                out.print(" ");
                out.print(this.numberFormat.format(coordY));
                out.print(" ");
                out.print("0.5000");
                out.print(" ");
                out.print("ic Blue");
                out.print(" ");
                out.print("bc Blue");
                out.print(" ");
                double nodeSize = (Double)((DoubleProperty)cluster.getProperties().getProperty(volumePropertyName)).getValue() * 10.0 / maxSize;
                out.print("x_fact " + Math.ceil(nodeSize));
                out.print(" ");
                out.println("y_fact " + Math.ceil(nodeSize));
                coordY += 1.0 / (double)this.clusterSets.get(periodIndex).getClustersCount();
            }
        }
        out.println("*edges");
        int gap = 0;
        for (periodIndex = 0; periodIndex < this.clusterSets.size() - 1; ++periodIndex) {
            ArrayList<Cluster> clustersPer1 = this.clusterSets.get(periodIndex).getClusters();
            ArrayList<Cluster> clustersPer2 = this.clusterSets.get(periodIndex + 1).getClusters();
            for (int i = 0; i < clustersPer1.size(); ++i) {
                Cluster clusterPer1 = clustersPer1.get(i);
                for (int j = 0; j < clustersPer2.size(); ++j) {
                    Cluster clusterPer2 = clustersPer2.get(j);
                    EvolutionMapNexus nexus = this.evolutionMap.getEvolutionNexus(gap, i, j);
                    if (nexus == null) continue;
                    out.print(((TreeMap)nodesIDs.get(periodIndex)).get(clusterPer1.getMainNode()));
                    out.print(" ");
                    out.print(((TreeMap)nodesIDs.get(periodIndex + 1)).get(clusterPer2.getMainNode()));
                    out.print(" ");
                    out.print(this.numberFormat.format(nexus.getWeight() * 10.0));
                    out.print(" ");
                    if (nexus.isShareMainNode()) {
                        out.println("c Blue");
                        continue;
                    }
                    out.println("c Gray95");
                }
            }
            ++gap;
        }
        out.close();
    }
}

