/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.visualization.graph;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.dataset.NetworkPair;
import scimat.api.mapping.Node;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.utils.property.DoubleProperty;

public class WholeNetworkPajek {
    private ClusterSet clusterSet;
    private String volumePropertyName;
    private String labelPropertyName;
    private String[] colors = new String[]{"Red", "Yellow", "Blue", "Green", "Pink", "Dandelion", "GreenYellow", "Lavender", "PineGreen", "Peach", "Magenta", "Fuchsia", "Bittersweet", "Salmon", "Mulberry", "RedViolet", "CornflowerBlue", "BlueGreen", "RawSienna", "Tan", "LightYellow", "LightCyan", "LightMagenta", "LightPurple", "MidnightBlue", "LFadedGreen", "Orchid", "Gray05", "Gray20", "Gray35", "Gray70", "Gray95"};
    private NumberFormat numberFormat = new DecimalFormat("0.0000");

    public WholeNetworkPajek(ClusterSet clusterSet, String frequencyKey, String nodeLabelKey) {
        this.clusterSet = clusterSet;
        this.volumePropertyName = frequencyKey;
        this.labelPropertyName = nodeLabelKey;
    }

    public void execute(String path, double maxSize) throws FileNotFoundException {
        int i;
        TreeMap<Integer, Integer> indexMap = new TreeMap<Integer, Integer>();
        PrintStream out = new PrintStream(path);
        ArrayList<Node> nodes = this.clusterSet.getWholeNetwork().getNodes();
        for (i = 0; i < nodes.size(); ++i) {
            indexMap.put(nodes.get(i).getNodeID(), i + 1);
        }
        out.println("*vertices " + this.clusterSet.getWholeNetwork().getNodesCount());
        for (i = 0; i < nodes.size(); ++i) {
            String icColor;
            String bcColor;
            Integer themeOfNode = this.clusterSet.getClusterOfNode(nodes.get(i).getNodeID());
            if (themeOfNode != -1) {
                icColor = themeOfNode < this.colors.length ? (bcColor = this.colors[themeOfNode]) : (bcColor = this.colors[this.colors.length - 1]);
            } else {
                icColor = "White";
                bcColor = "Black";
            }
            out.print(indexMap.get(nodes.get(i).getNodeID()));
            out.print(" ");
            out.print("\"" + nodes.get(i).getProperties().getProperty(this.labelPropertyName).getValue() + "\"");
            out.print(" ");
            out.print("ic " + icColor);
            out.print(" ");
            out.print("bc " + bcColor);
            out.print(" ");
            double nodeSize = (Double)((DoubleProperty)nodes.get(i).getProperties().getProperty(this.volumePropertyName)).getValue() * 10.0 / maxSize;
            out.print("x_fact " + Math.ceil(nodeSize));
            out.print(" ");
            out.println("y_fact " + Math.ceil(nodeSize));
        }
        ArrayList<NetworkPair> networkPairs = this.clusterSet.getWholeNetwork().getNetworkPairs();
        out.println("*edges");
        for (i = 0; i < networkPairs.size(); ++i) {
            NetworkPair networkPair = networkPairs.get(i);
            out.print(indexMap.get(networkPair.getID().getElementA()));
            out.print(" ");
            out.print(indexMap.get(networkPair.getID().getElementB()));
            out.print(" ");
            out.print(this.numberFormat.format(networkPair.getValue() * 10.0));
            out.print(" ");
            Integer themeOfNodeA = this.clusterSet.getClusterOfNode(networkPair.getID().getElementA());
            Integer themeOfNodeB = this.clusterSet.getClusterOfNode(networkPair.getID().getElementB());
            if (themeOfNodeA == themeOfNodeB) {
                if (themeOfNodeA != -1 && themeOfNodeA < this.colors.length) {
                    out.println("c " + this.colors[themeOfNodeA]);
                    continue;
                }
                out.println("c " + this.colors[this.colors.length - 1]);
                continue;
            }
            out.println("c Black");
        }
        out.close();
    }
}

