/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.visualization.graph;

import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import scimat.api.dataset.NetworkPair;
import scimat.api.mapping.WholeNetwork;
import scimat.api.mapping.clustering.result.Cluster;

public class ClusterNetworkSVG {
    private int width;
    private int maxRX;
    private int minRX;
    private int textPx;

    public ClusterNetworkSVG(int width, int maxRX, int minRX, int textPx) {
        this.width = width;
        this.maxRX = maxRX;
        this.minRX = minRX;
        this.textPx = textPx;
    }

    public Document buildXML(Cluster cluster, WholeNetwork wholeNetwork, String propertyKey, String labelPropertyKey, double maxSize) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf(this.width));
        svgRoot.setAttributeNS(null, "height", String.valueOf(this.width));
        svgRoot.setAttributeNS(null, "viewBox", "0 0 " + this.width + " " + this.width);
        this.addGradient(doc, svgNS, svgRoot);
        this.drawBox(doc, svgNS, svgRoot);
        this.drawNodes(doc, svgNS, svgRoot, cluster, wholeNetwork, maxSize, propertyKey, labelPropertyKey);
        return doc;
    }

    public Document buildEmptyXML() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf(this.width));
        svgRoot.setAttributeNS(null, "height", String.valueOf(this.width));
        svgRoot.setAttributeNS(null, "viewBox", "0 0 " + this.width + " " + this.width);
        this.addGradient(doc, svgNS, svgRoot);
        this.drawBox(doc, svgNS, svgRoot);
        return doc;
    }

    private double getNodeValue(WholeNetwork wholeNetwork, Integer nodeID, String propertyKey) {
        return (Double)wholeNetwork.getNode(nodeID).getProperties().getProperty(propertyKey).getValue();
    }

    private void addGradient(Document doc, String svgNS, Element element) {
        Element radialGradient = doc.createElementNS(svgNS, "radialGradient");
        radialGradient.setAttributeNS(null, "id", "sphereTheme");
        Element stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0");
        stop.setAttributeNS(null, "style", "stop-color:#C6DD3A");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.211");
        stop.setAttributeNS(null, "style", "stop-color:#C3DA39");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.3881");
        stop.setAttributeNS(null, "style", "stop-color:#B8CF37");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.5529");
        stop.setAttributeNS(null, "style", "stop-color:#A7BE34");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.7103");
        stop.setAttributeNS(null, "style", "stop-color:#8EA630");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.861");
        stop.setAttributeNS(null, "style", "stop-color:#6F872A");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "1");
        stop.setAttributeNS(null, "style", "stop-color:#4B6323");
        radialGradient.appendChild(stop);
        element.appendChild(radialGradient);
    }

    private void drawBox(Document doc, String svgNS, Element element) {
        int maxCoord = this.width - 1;
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", "0");
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y2", "0");
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", "0");
        subElement.setAttributeNS(null, "y1", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "x2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", "0");
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", "0");
        subElement.setAttributeNS(null, "y2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
    }

    private void drawNodes(Document doc, String svgNS, Element element, Cluster cluster, WholeNetwork wholeNetwork, double maxSize, String propertyKey, String labelPropertyKey) {
        Element subElement;
        double[] coord;
        int i;
        TreeMap<Integer, double[]> coordMap = new TreeMap<Integer, double[]>();
        ArrayList<Integer> nodes = cluster.getNodes();
        if (maxSize == 0.0) {
            for (i = 0; i < nodes.size(); ++i) {
                double nodeSize = this.getNodeValue(wholeNetwork, nodes.get(i), propertyKey);
                if (!(maxSize < nodeSize)) continue;
                maxSize = nodeSize;
            }
        }
        int realWidth = this.width - 2 * this.maxRX;
        double radius = realWidth / 2;
        double angle = Math.PI * 2 / (double)(cluster.getNodesCount() - 1);
        double currentAngle = 0.39269908169872414;
        for (i = 0; i < nodes.size(); ++i) {
            coord = new double[2];
            if (cluster.getMainNode().equals(nodes.get(i))) {
                coord[0] = coord[1] = (double)(realWidth / 2 + this.maxRX);
            } else {
                coord[0] = Math.cos(currentAngle) * radius + (double)(realWidth / 2) + (double)this.maxRX;
                coord[1] = Math.sin(currentAngle) * radius + (double)(realWidth / 2) + (double)this.maxRX;
                currentAngle += angle;
            }
            coordMap.put(nodes.get(i), coord);
        }
        ArrayList<NetworkPair> pairs = wholeNetwork.getInternalPairs(cluster.getNodes());
        for (i = 0; i < pairs.size(); ++i) {
            NetworkPair pair = pairs.get(i);
            double lineWidth = pair.getValue() * 10.0;
            double[] coordNodeA = (double[])coordMap.get(pair.getID().getElementA());
            double[] coordNodeB = (double[])coordMap.get(pair.getID().getElementB());
            subElement = doc.createElementNS(svgNS, "line");
            subElement.setAttributeNS(null, "x1", String.valueOf(coordNodeA[0]));
            subElement.setAttributeNS(null, "y1", String.valueOf(coordNodeA[1]));
            subElement.setAttributeNS(null, "x2", String.valueOf(coordNodeB[0]));
            subElement.setAttributeNS(null, "y2", String.valueOf(coordNodeB[1]));
            subElement.setAttributeNS(null, "stroke", "black");
            subElement.setAttributeNS(null, "stroke-width", "1");
            subElement.setAttributeNS(null, "style", "stroke-width:" + lineWidth + ";stroke-miterlimit:4;stroke-dasharray:none;" + "stroke-linecap:round;stroke-opacity:0.5");
            element.appendChild(subElement);
        }
        for (i = 0; i < nodes.size(); ++i) {
            coord = (double[])coordMap.get(nodes.get(i));
            subElement = doc.createElementNS(svgNS, "circle");
            subElement.setAttributeNS(null, "cx", String.valueOf(coord[0]));
            subElement.setAttributeNS(null, "cy", String.valueOf(coord[1]));
            subElement.setAttributeNS(null, "r", String.valueOf(this.getNodeValue(wholeNetwork, nodes.get(i), propertyKey) / maxSize * (double)(this.maxRX - this.minRX) + (double)this.minRX));
            subElement.setAttributeNS(null, "id", "circle" + i);
            subElement.setAttributeNS(null, "style", "fill:url(#sphereTheme);stroke-width:0.50000000000000000;fill-opacity:1;stroke-opacity:1");
            element.appendChild(subElement);
            subElement = doc.createElementNS(svgNS, "text");
            subElement.setAttributeNS(null, "x", String.valueOf(coord[0]));
            subElement.setAttributeNS(null, "y", String.valueOf(coord[1]));
            subElement.setAttributeNS(null, "id", "text5" + i);
            subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;text-anchor:middle;fill:#000000;font-family:Verdana");
            subElement.setTextContent((String)wholeNetwork.getNode(nodes.get(i)).getProperties().getProperty(labelPropertyKey).getValue());
            element.appendChild(subElement);
        }
    }
}

