/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.visualization.category;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import scimat.api.analysis.category.StrategicDiagram;
import scimat.api.analysis.category.StrategicDiagramItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategicDiagramSVG {
    private int width;
    private int maxRX;
    private int minRX;
    private int textPx;
    private NumberFormat numberFormatter = new DecimalFormat(",##0.##");

    public StrategicDiagramSVG(int width, int maxRX, int minRX, int textPx) {
        this.width = width;
        this.maxRX = maxRX;
        this.minRX = minRX;
        this.textPx = textPx;
    }

    public Document buildXML(StrategicDiagram strategicDiagram) {
        ArrayList<StrategicDiagramItem> strategicDiagramItems = strategicDiagram.getItems();
        Collections.sort(strategicDiagramItems, new Comparator<StrategicDiagramItem>(){

            @Override
            public int compare(StrategicDiagramItem o1, StrategicDiagramItem o2) {
                return Double.valueOf(o2.getVolume()).compareTo(o1.getVolume());
            }
        });
        double maxSize = strategicDiagramItems.size() > 0 ? strategicDiagramItems.get(0).getVolume() : 0.0;
        int realWidth = this.width - 2 * this.maxRX;
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf(this.width));
        svgRoot.setAttributeNS(null, "height", String.valueOf(this.width));
        svgRoot.setAttributeNS(null, "viewBox", "0 0 " + this.width + " " + this.width);
        this.addGradient(doc, svgNS, svgRoot);
        this.drawAxis(doc, svgNS, svgRoot, this.maxRX);
        this.drawBox(doc, svgNS, svgRoot);
        this.drawCluster(doc, svgNS, svgRoot, strategicDiagramItems, realWidth, realWidth, maxSize);
        return doc;
    }

    private void addGradient(Document doc, String svgNS, Element element) {
        Element radialGradient = doc.createElementNS(svgNS, "radialGradient");
        radialGradient.setAttributeNS(null, "id", "sphereTheme");
        Element stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0");
        stop.setAttributeNS(null, "style", "stop-color:#C6DD3A");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.211");
        stop.setAttributeNS(null, "style", "stop-color:#C3DA39");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.3881");
        stop.setAttributeNS(null, "style", "stop-color:#B8CF37");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.5529");
        stop.setAttributeNS(null, "style", "stop-color:#A7BE34");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.7103");
        stop.setAttributeNS(null, "style", "stop-color:#8EA630");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "0.861");
        stop.setAttributeNS(null, "style", "stop-color:#6F872A");
        radialGradient.appendChild(stop);
        stop = doc.createElementNS(svgNS, "stop");
        stop.setAttributeNS(null, "offset", "1");
        stop.setAttributeNS(null, "style", "stop-color:#4B6323");
        radialGradient.appendChild(stop);
        element.appendChild(radialGradient);
    }

    private void drawAxis(Document doc, String svgNS, Element element, int maxRX) {
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(maxRX));
        subElement.setAttributeNS(null, "y1", String.valueOf(this.width / 2));
        subElement.setAttributeNS(null, "x2", String.valueOf(this.width - maxRX));
        subElement.setAttributeNS(null, "y2", String.valueOf(this.width / 2));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(this.width / 2));
        subElement.setAttributeNS(null, "y1", String.valueOf(maxRX));
        subElement.setAttributeNS(null, "x2", String.valueOf(this.width / 2));
        subElement.setAttributeNS(null, "y2", String.valueOf(this.width - maxRX));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "text");
        subElement.setAttributeNS(null, "x", String.valueOf(this.width - maxRX - 10));
        subElement.setAttributeNS(null, "y", String.valueOf(this.width / 2));
        subElement.setAttributeNS(null, "id", "text23");
        subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;text-anchor:end;fill:#000000;font-family:Verdana");
        subElement.setTextContent("centrality");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "text");
        subElement.setAttributeNS(null, "x", String.valueOf(this.width / 2));
        subElement.setAttributeNS(null, "y", String.valueOf(maxRX));
        subElement.setAttributeNS(null, "id", "text24");
        subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;text-anchor:end;fill:#000000;font-family:Verdana");
        subElement.setTextContent("density");
        element.appendChild(subElement);
    }

    private void drawBox(Document doc, String svgNS, Element element) {
        int maxCoord = this.width - 1;
        Element subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", "0");
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y2", "0");
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", "0");
        subElement.setAttributeNS(null, "y1", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "x2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", "0");
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", "0");
        subElement.setAttributeNS(null, "y2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
        subElement = doc.createElementNS(svgNS, "line");
        subElement.setAttributeNS(null, "x1", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y1", "0");
        subElement.setAttributeNS(null, "x2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "y2", String.valueOf(maxCoord));
        subElement.setAttributeNS(null, "stroke", "black");
        subElement.setAttributeNS(null, "stroke-width", "1");
        element.appendChild(subElement);
    }

    private void drawCluster(Document doc, String svgNS, Element element, ArrayList<StrategicDiagramItem> strategicDiagramItems, int realWidth, int realHeight, double maxSize) {
        for (int i = 0; i < strategicDiagramItems.size(); ++i) {
            Element subElement;
            StrategicDiagramItem item = strategicDiagramItems.get(i);
            double x = item.getValueAxisX() * (double)realWidth + (double)this.maxRX;
            double y = Math.abs(item.getValueAxisY() * (double)realHeight - (double)realHeight) + (double)this.maxRX;
            double size = item.getVolume() / maxSize * (double)(this.maxRX - this.minRX) + (double)this.minRX;
            if (size > 0.0) {
                subElement = doc.createElementNS(svgNS, "circle");
                subElement.setAttributeNS(null, "cx", String.valueOf(x));
                subElement.setAttributeNS(null, "cy", String.valueOf(y));
                subElement.setAttributeNS(null, "r", String.valueOf(size));
                subElement.setAttributeNS(null, "id", "circle15");
                subElement.setAttributeNS(null, "style", "opacity:1;fill:url(#sphereTheme);fill-opacity:1;fill-rule:nonzero;stroke:#000000;stroke-width:0.58200002;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1");
                element.appendChild(subElement);
            }
            subElement = doc.createElementNS(svgNS, "text");
            subElement.setAttributeNS(null, "x", String.valueOf(x));
            subElement.setAttributeNS(null, "y", String.valueOf(y));
            subElement.setAttributeNS(null, "id", "text23");
            subElement.setAttributeNS(null, "style", "font-size:" + this.textPx + "px;text-anchor:middle;fill:#000000;font-family:Verdana");
            subElement.setTextContent(item.getLabel());
            Element tspanElement = doc.createElementNS(svgNS, "tspan");
            tspanElement.setAttribute("x", String.valueOf(x));
            tspanElement.setAttribute("y", String.valueOf(y + 15.0));
            tspanElement.setAttributeNS(null, "id", "text25");
            tspanElement.setTextContent(this.numberFormatter.format(item.getVolume()));
            subElement.appendChild(tspanElement);
            element.appendChild(subElement);
        }
    }
}

