/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.similaritymeasure;

import java.util.ArrayList;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.NetworkPair;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.similaritymeasure.Normalizer;
import scimat.api.similaritymeasure.direct.DirectSimilarityMeasure;

public class CouplingNormalizer
implements Normalizer {
    private DirectSimilarityMeasure measure;

    public CouplingNormalizer(DirectSimilarityMeasure measure) {
        this.measure = measure;
    }

    public void execute(Dataset dataset, UndirectNetworkMatrix network) throws NotExistsItemException {
        ArrayList<NetworkPair> pairs = network.getNetworkPairs();
        for (int i = 0; i < pairs.size(); ++i) {
            double normalizedValue;
            NetworkPair pair = pairs.get(i);
            if (dataset instanceof AggregatedDataset) {
                AggregatedDataset aggregatedDataset = (AggregatedDataset)dataset;
                normalizedValue = this.measure.calculateMeasure(aggregatedDataset.getDocumentsInHighLevelItemCount(pair.getID().getElementA()), aggregatedDataset.getDocumentsInHighLevelItemCount(pair.getID().getElementB()), pair.getValue());
            } else {
                normalizedValue = this.measure.calculateMeasure(dataset.getDocumentFrequency(pair.getID().getElementA()), dataset.getDocumentFrequency(pair.getID().getElementB()), pair.getValue());
            }
            network.addEdge(pair.getID().getElementA(), pair.getID().getElementB(), normalizedValue);
        }
    }
}

