/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.similaritymeasure;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.NetworkPair;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.similaritymeasure.Normalizer;
import scimat.api.similaritymeasure.direct.DirectSimilarityMeasure;

public class CoOccurrenceNormalizer
implements Normalizer {
    private DirectSimilarityMeasure measure;

    public CoOccurrenceNormalizer(DirectSimilarityMeasure measure) {
        this.measure = measure;
    }

    public void execute(Dataset dataset, UndirectNetworkMatrix network) throws NotExistsItemException {
        ArrayList<NetworkPair> pairs = network.getNetworkPairs();
        for (int i = 0; i < pairs.size(); ++i) {
            NetworkPair pair = pairs.get(i);
            double normalizedValue = this.measure.calculateMeasure(dataset.getItemFrequency(pair.getID().getElementA()), dataset.getItemFrequency(pair.getID().getElementB()), pair.getValue());
            network.addEdge(pair.getID().getElementA(), pair.getID().getElementB(), normalizedValue);
        }
    }
}

