/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.report;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.commons.lang.StringEscapeUtils;
import scimat.analysis.AnalysisPeriodResult;
import scimat.analysis.BuildPerformanceMeasuresAvailable;
import scimat.analysis.ClusteringAlgorithmEnum;
import scimat.analysis.GlobalAnalysisResult;
import scimat.analysis.PerformanceMeasuresAvailable;
import scimat.api.analysis.category.StrategicDiagram;
import scimat.api.analysis.category.StrategicDiagramBuildier;
import scimat.api.dataset.NetworkPair;
import scimat.api.mapping.Node;
import scimat.api.mapping.WholeNetwork;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.report.ReportBuilderException;
import scimat.api.report.ReportGenericBuilder;
import scimat.api.utils.image.TranscoderSVGtoPNG;
import scimat.api.utils.xml.DomToString;
import scimat.api.visualization.category.StrategicDiagramSVG;
import scimat.api.visualization.graph.ClusterNetworkSVG;
import scimat.api.visualization.graph.WholeNetworkPajek;
import scimat.api.visualization.temporal.EvolutionMapPajek;
import scimat.api.visualization.temporal.EvolutionMapSVG;
import scimat.api.visualization.temporal.OverlappingMapSVG;
import scimat.model.knowledgebase.entity.Period;

public class MakeReportHTML
implements ReportGenericBuilder {
    private static String __MISC_FOLDER_NAME = "misc";
    private static String __IMAGES_FOLDER_NAME = "images";
    private static int __TEXT_PX = 12;
    private static int __STRATEGIC_DIAGRAM_BIG_WIDTH = 800;
    private static int __STRATEGIC_DIAGRAM_FILE_WIDTH = 800;
    private static int __STRATEGIC_DIAGRAM_MAX_RADIUS = 60;
    private static int __STRATEGIC_DIAGRAM_MIN_RADIUS = 20;
    private static int __CLUSTER_NETWORK_BIG_WIDTH = 800;
    private static int __CLUSTER_NETWORK_FILE_WIDTH = 800;
    private static int __CLUSTER_NETWORK_MAX_RADIUS = 100;
    private static int __CLUSTER_NETWORK_MIN_RADIUS = 20;
    private static String __PNG_EXTENSION = "png";
    private static String __SVG_EXTENSION = "svg";
    private String path;
    private NumberFormat numberFormatter = new DecimalFormat(",##0.##");
    private GlobalAnalysisResult globalExperimentResult;
    private ArrayList<PerformanceMeasuresAvailable> performanceMeasuresAvailable;
    private DomToString domToString;

    public MakeReportHTML(String path, GlobalAnalysisResult globalExperimentResult) {
        this.path = path;
        this.globalExperimentResult = globalExperimentResult;
        this.performanceMeasuresAvailable = new BuildPerformanceMeasuresAvailable().build();
        this.domToString = new DomToString();
    }

    public void execute() throws ReportBuilderException {
        try {
            this.makeFolderStructure();
            this.doMainHTMLPage();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new ReportBuilderException(e);
        }
    }

    private void doMainHTMLPage() throws FileNotFoundException, IOException, TranscoderException {
        int i;
        PrintStream out = new PrintStream(this.getFileAbsolutePathMainHTMLPage());
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es\">");
        out.println("  <head>");
        out.println("    <title>SciMAT report</title>");
        out.println("  </head>");
        out.println("  <body>");
        out.println("    <h1>SciMAT HTML report</h1>");
        out.println("    <p>This resport has been automatically generated by SciMAT</p>");
        out.println("    <hr/>");
        out.println("    <h2>Analysis Configuration</h2>");
        out.println("    <ul>");
        out.print("      <li>Unit of analysis: ");
        switch (this.globalExperimentResult.getAnalysisConfiguration().getUnitOfAnalysis()) {
            case Authors: {
                out.print("Authors");
                break;
            }
            case Words: {
                out.print("Words (authorRole=" + this.globalExperimentResult.getAnalysisConfiguration().isAuthorWords() + ", sourceRole=" + this.globalExperimentResult.getAnalysisConfiguration().isSourceWords() + ", addedRole=" + this.globalExperimentResult.getAnalysisConfiguration().isExtractedWords() + ")");
                break;
            }
            case References: {
                out.print("References");
                break;
            }
            case AuthorsReference: {
                out.print("Author-References");
                break;
            }
            case ReferenceSources: {
                out.print("Source-References");
            }
        }
        out.println("</li>");
        out.print("      <li>Kind of network: ");
        switch (this.globalExperimentResult.getAnalysisConfiguration().getKindOfMatrix()) {
            case CoOccurrence: {
                out.print("Co-occurence");
                break;
            }
            case BasicCoupling: {
                out.print("Basic coupling");
                break;
            }
            case AggregatedCouplingBasedOnAuthor: {
                out.print("Aggregated coupling based on author");
                break;
            }
            case AggregatedCouplingBasedOnJournal: {
                out.print("Aggregated coupling base on journal");
            }
        }
        out.println("</li>");
        out.print("      <li>Normalization measure: ");
        switch (this.globalExperimentResult.getAnalysisConfiguration().getNormalizationMeasure()) {
            case AssociationStrength: {
                out.print("Association strength");
                break;
            }
            case EquivalenceIndex: {
                out.print("Equivalence index");
                break;
            }
            case InclusionIndex: {
                out.print("Inclusion index");
                break;
            }
            case JaccardIndex: {
                out.print("Jaccard index");
                break;
            }
            case SaltonCosine: {
                out.print("Salton cosine");
            }
        }
        out.println("</li>");
        out.print("      <li>Cluster algorithm: ");
        switch (this.globalExperimentResult.getAnalysisConfiguration().getClusteringAlgorithm()) {
            case CentersSimples: {
                out.println("Centers simples");
                break;
            }
            case SingleLink: {
                out.println("Single link");
                break;
            }
            case CompleteLink: {
                out.println("Complete link");
                break;
            }
            case AverageLink: {
                out.println("Average link");
                break;
            }
            case SumLink: {
                out.println("Sum link");
            }
        }
        out.println("        <ul>");
        out.println("          <li>Max cluster size: " + this.globalExperimentResult.getAnalysisConfiguration().getMaxNetworkSize() + "</li>");
        out.println("          <li>Min cluster size: " + this.globalExperimentResult.getAnalysisConfiguration().getMinNetworkSize() + "</li>");
        if (this.globalExperimentResult.getAnalysisConfiguration().getClusteringAlgorithm().equals(ClusteringAlgorithmEnum.SingleLink) || this.globalExperimentResult.getAnalysisConfiguration().getClusteringAlgorithm().equals(ClusteringAlgorithmEnum.CompleteLink) || this.globalExperimentResult.getAnalysisConfiguration().getClusteringAlgorithm().equals(ClusteringAlgorithmEnum.AverageLink) || this.globalExperimentResult.getAnalysisConfiguration().getClusteringAlgorithm().equals(ClusteringAlgorithmEnum.SumLink)) {
            out.println("          <li>Cutt off: " + this.globalExperimentResult.getAnalysisConfiguration().getCutOff() + "</li>");
        }
        out.println("        </ul>");
        out.println("      </li>");
        out.print("      <li>Evolution measure: ");
        switch (this.globalExperimentResult.getAnalysisConfiguration().getEvolutionMapMeasure()) {
            case AssociationStrength: {
                out.print("Association strength");
                break;
            }
            case EquivalenceIndex: {
                out.print("Equivalence index");
                break;
            }
            case InclusionIndex: {
                out.print("Inclusion index");
                break;
            }
            case JaccardIndex: {
                out.print("Jaccard index");
                break;
            }
            case SaltonCosine: {
                out.print("Salton cosine");
            }
        }
        out.println("</li>");
        out.print("      <li>Overlapping measure: ");
        switch (this.globalExperimentResult.getAnalysisConfiguration().getOverlappingMapMeasure()) {
            case AssociationStrength: {
                out.print("Association strength");
                break;
            }
            case EquivalenceIndex: {
                out.print("Equivalence index");
                break;
            }
            case InclusionIndex: {
                out.print("Inclusion index");
                break;
            }
            case JaccardIndex: {
                out.print("Jaccard index");
                break;
            }
            case SaltonCosine: {
                out.print("Salton cosine");
            }
        }
        out.println("</li>");
        out.println("    </ul>");
        out.println("    <h2>Period's results</h2>");
        out.println("    <ul>");
        ArrayList<Period> periods = this.globalExperimentResult.getAnalysisConfiguration().getPeriods();
        for (i = 0; i < periods.size(); ++i) {
            String escapedPeriodName = StringEscapeUtils.escapeHtml((String)periods.get(i).getName());
            out.println("      <li><a href=\"" + this.getFilePathPeriodHTMLPage(i) + "\">" + escapedPeriodName + "</a></li>");
            this.doPeriodHTLMPage(escapedPeriodName, i, this.globalExperimentResult.getAnalysisPeriodResult(i));
        }
        out.println("    </ul>");
        out.println("    <h2>Longidtudinal results</h2>");
        out.println("    <h3>Overlapping map</h3>");
        OverlappingMapSVG overlappingMapSVG = new OverlappingMapSVG(40, 80, 40, 10);
        String svg = this.domToString.convert(overlappingMapSVG.buildXML(this.globalExperimentResult.getLongitudinalResult().getOverlappingMap()));
        this.svgToFile(this.getFileAbsolutePathOverlappingMap(__SVG_EXTENSION), svg);
        TranscoderSVGtoPNG.transcoder(this.getFileAbsolutePathOverlappingMap(__SVG_EXTENSION), this.getFileAbsolutePathOverlappingMap(__PNG_EXTENSION));
        out.println("      <img alt=\"Overlapping map\" src=\"" + this.getFilePathOverlappingMap(__PNG_EXTENSION) + "\"/>");
        out.println("    <h3>Evolution map</h3>");
        EvolutionMapSVG evolutionMapSVG = new EvolutionMapSVG(5, 30, 150, 0, 10);
        out.println("      <table border=\"1\" summary=\"this table shows the evolution maps\">");
        out.println("        <caption><em>Evolution maps</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Performance measure</td>");
        out.println("          <td>Evolution map</td>");
        out.println("          <td>Pajek file</td>");
        out.println("        </tr>");
        ArrayList<ClusterSet> clusterSets = new ArrayList<ClusterSet>();
        for (i = 0; i < this.globalExperimentResult.getAnalysisPeriodResultsCount(); ++i) {
            clusterSets.add(this.globalExperimentResult.getAnalysisPeriodResult(i).getClusterSet());
        }
        EvolutionMapPajek evolutionMapPajek = new EvolutionMapPajek(clusterSets, this.globalExperimentResult.getLongitudinalResult().getEvolutionMap());
        for (i = 0; i < this.performanceMeasuresAvailable.size(); ++i) {
            PerformanceMeasuresAvailable measuresAvailable = this.performanceMeasuresAvailable.get(i);
            svg = this.domToString.convert(evolutionMapSVG.buildXML(clusterSets, this.globalExperimentResult.getLongitudinalResult().getEvolutionMap(), measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), "clusterName"));
            this.svgToFile(this.getFileAbsolutePathEvolutionMap(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __SVG_EXTENSION), svg);
            TranscoderSVGtoPNG.transcoder(this.getFileAbsolutePathEvolutionMap(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __SVG_EXTENSION), this.getFileAbsolutePathEvolutionMap(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __PNG_EXTENSION));
            out.println("        <tr>");
            out.println("          <td>" + measuresAvailable.getMapper() + "-" + measuresAvailable.getPropertyKey() + "</td>");
            out.println("          <td><img alt=\"Evolution map\" src=\"" + this.getFilePathEvolutiongMap(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __PNG_EXTENSION) + "\"/></td>");
            evolutionMapPajek.execute(this.getFileAbsolutePathEvolutionMapPajek(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey()), measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), "clusterName");
            out.println("          <td><a href=\"" + this.getFilePathEvolutiongMapPajek(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey()) + "\">Pakej file</a></td>");
            out.println("        </tr>");
        }
        out.println("      </table>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
    }

    private void doPeriodHTLMPage(String escapedPeriodName, int periodPosition, AnalysisPeriodResult results) throws FileNotFoundException, IOException, TranscoderException {
        Cluster cluster;
        String svg;
        PerformanceMeasuresAvailable measuresAvailable;
        int clusterIndex;
        PrintStream out = new PrintStream(this.getFileAbsolutePathPeriodHTMLPage(periodPosition));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es\">");
        out.println("<head>");
        out.println("    <title>SciMAT report - subperiod " + escapedPeriodName + "</title>");
        out.println("  </head>");
        out.println("  <body>");
        out.println("    <h1>SciMAT HTML report - " + escapedPeriodName + "</h1>");
        out.println("    <hr/>");
        out.println("    <h2>Period's parameters</h2>");
        out.println("    <ul>");
        out.println("      <li>Min frequency: " + this.globalExperimentResult.getAnalysisConfiguration().getMinFrequency(periodPosition) + "</li>");
        out.println("      <li>Min co-occurrence: " + this.globalExperimentResult.getAnalysisConfiguration().getMinCoOccurrence(periodPosition) + "</li>");
        out.println("    </ul>");
        out.println("    <h2>Strategic diagrams</h2>");
        StrategicDiagramBuildier strategicDiagramBuildier = new StrategicDiagramBuildier("callonCentralityRange", "callonDensityRange", "clusterName");
        StrategicDiagramSVG strategicDiagramSVG = new StrategicDiagramSVG(__STRATEGIC_DIAGRAM_FILE_WIDTH, __STRATEGIC_DIAGRAM_MAX_RADIUS, __STRATEGIC_DIAGRAM_MIN_RADIUS, __TEXT_PX);
        out.println("      <table border=\"1\" summary=\"this table shows the strategic diagram of the period " + escapedPeriodName + "\">");
        out.println("        <caption><em>Strategic diagram</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Performance measure</td>");
        out.println("          <td>Strategic diagram</td>");
        out.println("        </tr>");
        for (clusterIndex = 0; clusterIndex < this.performanceMeasuresAvailable.size(); ++clusterIndex) {
            measuresAvailable = this.performanceMeasuresAvailable.get(clusterIndex);
            StrategicDiagram strategicDiagram = strategicDiagramBuildier.buildStrategicDiagram(results.getClusterSet(), measuresAvailable.getMapper() + measuresAvailable.getPropertyKey());
            svg = this.domToString.convert(strategicDiagramSVG.buildXML(strategicDiagram));
            this.svgToFile(this.getFileAbsolutePathStrategicDiagram(periodPosition, measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __SVG_EXTENSION), svg);
            TranscoderSVGtoPNG.transcoder(this.getFileAbsolutePathStrategicDiagram(periodPosition, measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __SVG_EXTENSION), this.getFileAbsolutePathStrategicDiagram(periodPosition, measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __PNG_EXTENSION));
            out.println("        <tr>");
            out.println("          <td>" + measuresAvailable.getMapper() + "-" + measuresAvailable.getPropertyKey() + "</td>");
            out.println("          <td><img alt=\"Strategic diagram of the period " + periodPosition + "\" src=\"" + this.getFilePathStrategicDiagram(periodPosition, measuresAvailable.getMapper() + measuresAvailable.getPropertyKey(), __PNG_EXTENSION) + "\" width=\"" + __STRATEGIC_DIAGRAM_BIG_WIDTH + "\" /></td>");
            out.println("        </tr>");
        }
        out.println("      </table>");
        out.println("    <h2>Whole network</h2>");
        double maxFrequency = this.maxPeriodNodeFrequency(results.getClusterSet().getWholeNetwork());
        WholeNetworkPajek wholeNetworkPajek = new WholeNetworkPajek(results.getClusterSet(), "nodeFrequency", "nodeName");
        wholeNetworkPajek.execute(this.getFileAbsolutePathWholeNetworkPajek(periodPosition), maxFrequency);
        out.println("      <a href=\"" + this.getFilePathWholeNetworkPajekm(periodPosition) + "\">Whole network - Pajek File</a>");
        out.println("    <h2>Clusters</h2>");
        out.println("      <table border=\"1\" summary=\"this table shows the basic measures of the clusters of the period " + escapedPeriodName + "\">");
        out.println("        <caption><em>Clusters information</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Name</td>");
        out.println("          <td>Centrality</td>");
        out.println("          <td>Centrality range</td>");
        out.println("          <td>Density</td>");
        out.println("          <td>Density range</td>");
        out.println("        </tr>");
        for (clusterIndex = 0; clusterIndex < results.getClusterSet().getClustersCount(); ++clusterIndex) {
            cluster = results.getClusterSet().getCluster(clusterIndex);
            out.println("        <tr>");
            out.println("          <td>" + StringEscapeUtils.escapeHtml((String)cluster.getProperties().getProperty("clusterName").toString()) + "</td>");
            out.println("          <td>" + this.numberFormatter.format(cluster.getProperties().getProperty("callonCentrality").getValue()) + "</td>");
            out.println("          <td>" + this.numberFormatter.format(cluster.getProperties().getProperty("callonCentralityRange").getValue()) + "</td>");
            out.println("          <td>" + this.numberFormatter.format(cluster.getProperties().getProperty("callonDensity").getValue()) + "</td>");
            out.println("          <td>" + this.numberFormatter.format(cluster.getProperties().getProperty("callonDensityRange").getValue()) + "</td>");
            out.println("        </tr>");
        }
        out.println("      </table>");
        out.println("      <table border=\"1\" summary=\"this table shows the performance measures of the clusters of the period " + escapedPeriodName + "\">");
        out.println("        <caption><em>Clusters information</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Name</td>");
        for (clusterIndex = 0; clusterIndex < this.performanceMeasuresAvailable.size(); ++clusterIndex) {
            measuresAvailable = this.performanceMeasuresAvailable.get(clusterIndex);
            out.println("          <td>" + measuresAvailable.getMapper() + measuresAvailable.getPropertyKey() + "</td>");
        }
        out.println("        </tr>");
        for (clusterIndex = 0; clusterIndex < results.getClusterSet().getClustersCount(); ++clusterIndex) {
            cluster = results.getClusterSet().getCluster(clusterIndex);
            out.println("        <tr>");
            out.println("          <td>" + StringEscapeUtils.escapeHtml((String)cluster.getProperties().getProperty("clusterName").toString()) + "</td>");
            for (int j = 0; j < this.performanceMeasuresAvailable.size(); ++j) {
                measuresAvailable = this.performanceMeasuresAvailable.get(j);
                out.println("          <td>" + this.numberFormatter.format(cluster.getProperties().getProperty(measuresAvailable.getMapper() + measuresAvailable.getPropertyKey()).getValue()) + "</td>");
            }
            out.println("        </tr>");
        }
        out.println("      </table>");
        out.println("    <h2>Clusters' network</h2>");
        ClusterNetworkSVG clusterNetworkSVG = new ClusterNetworkSVG(__CLUSTER_NETWORK_FILE_WIDTH, __CLUSTER_NETWORK_MAX_RADIUS, __CLUSTER_NETWORK_MIN_RADIUS, __TEXT_PX);
        out.println("      <table border=\"1\" summary=\"this table shows the performance measures of the clusters of the period " + escapedPeriodName + "\">");
        out.println("        <caption><em>Clusters information</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Name</td>");
        out.println("          <td>Cluster's network</td>");
        out.println("        </tr>");
        for (clusterIndex = 0; clusterIndex < results.getClusterSet().getClustersCount(); ++clusterIndex) {
            cluster = results.getClusterSet().getCluster(clusterIndex);
            svg = this.domToString.convert(clusterNetworkSVG.buildXML(cluster, results.getClusterSet().getWholeNetwork(), "nodeFrequency", "nodeName", maxFrequency));
            this.svgToFile(this.getFileAbsolutePathClusterNetwork(periodPosition, clusterIndex, __SVG_EXTENSION), svg);
            TranscoderSVGtoPNG.transcoder(this.getFileAbsolutePathClusterNetwork(periodPosition, clusterIndex, __SVG_EXTENSION), this.getFileAbsolutePathClusterNetwork(periodPosition, clusterIndex, __PNG_EXTENSION));
            String escapedClusterName = StringEscapeUtils.escapeHtml((String)cluster.getProperties().getProperty("clusterName").toString());
            out.println("        <tr>");
            out.println("          <td><a href=\"" + this.getFilePathClusterHTMLPage(periodPosition, clusterIndex) + "\">" + escapedClusterName + "</td>");
            out.println("          <td><img alt=\"Cluster network\" src=\"" + this.getFilePathClusterNetwork(periodPosition, clusterIndex, __PNG_EXTENSION) + "\" width=\"" + __CLUSTER_NETWORK_BIG_WIDTH + "\" /></td>");
            out.println("        </tr>");
            this.doClusterHTLMPage(periodPosition, escapedPeriodName, escapedClusterName, cluster, clusterIndex, results.getClusterSet());
        }
        out.println("      </table>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
    }

    private void doClusterHTLMPage(int periodPosition, String escapedPeriodName, String escapedClusterName, Cluster cluster, int clusterIndex, ClusterSet clusterSet) throws FileNotFoundException, IOException, TranscoderException {
        NetworkPair pair;
        int i;
        PrintStream out = new PrintStream(this.getFileAbsolutePathClusterHTMLPage(periodPosition, clusterIndex));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es\">");
        out.println("<head>");
        out.println("    <title>SciMAT report - subperiod " + escapedPeriodName + " - cluster " + escapedClusterName + "</title>");
        out.println("  </head>");
        out.println("  <body>");
        out.println("    <h1>SciMAT report - subperiod " + escapedPeriodName + " - cluster " + escapedClusterName + "</h1>");
        out.println("    <hr/>");
        out.println("    <h2>Cluster info:</h2>");
        out.println("    <ul>");
        out.println("      <li>Name: " + escapedClusterName + "</li>");
        out.println("      <li>Density: " + this.numberFormatter.format(cluster.getProperties().getProperty("callonDensity").getValue()) + "</li>");
        out.println("      <li>Densisty range: " + this.numberFormatter.format(cluster.getProperties().getProperty("callonDensityRange").getValue()) + "</li>");
        out.println("      <li>Centrality: " + this.numberFormatter.format(cluster.getProperties().getProperty("callonCentrality").getValue()) + "</li>");
        out.println("      <li>Centrality range: " + this.numberFormatter.format(cluster.getProperties().getProperty("callonCentralityRange").getValue()) + "</li>");
        out.println("    </ul>");
        out.println("    <h2>Cluster network:</h2>");
        out.println("<img alt=\"Cluster network\" src=\"" + this.getFilePathClusterNetwork(periodPosition, clusterIndex, __PNG_EXTENSION) + "\" width=\"" + __CLUSTER_NETWORK_BIG_WIDTH + "\" />");
        out.println("    <h2>Internal links:</h2>");
        out.println("      <table border=\"1\" summary=\"this table shows the internal links of the cluster " + escapedClusterName + " of the period " + escapedPeriodName + "\">");
        out.println("        <caption><em>Internal links</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Node A</td>");
        out.println("          <td>Node B</td>");
        out.println("          <td>Weight</td>");
        out.println("        </tr>");
        ArrayList<NetworkPair> pairs = clusterSet.getClusterInternalPairs(clusterIndex);
        for (i = 0; i < pairs.size(); ++i) {
            pair = pairs.get(i);
            out.println("        <tr>");
            out.println("          <td>" + StringEscapeUtils.escapeHtml((String)clusterSet.getWholeNetwork().getNode(pair.getID().getElementA()).getProperties().getProperty("nodeName").getValue().toString()) + "</td>");
            out.println("          <td>" + StringEscapeUtils.escapeHtml((String)clusterSet.getWholeNetwork().getNode(pair.getID().getElementB()).getProperties().getProperty("nodeName").getValue().toString()) + "</td>");
            out.println("          <td>" + this.numberFormatter.format(pair.getValue()) + "</td>");
            out.println("        </tr>");
        }
        out.println("      </table>");
        out.println("    <h2>External links:</h2>");
        out.println("      <table border=\"1\" summary=\"this table shows the external links of the cluster " + escapedClusterName + " of the period " + escapedPeriodName + "\">");
        out.println("        <caption><em>External links</em></caption>");
        out.println("        <tr>");
        out.println("          <td>Node A</td>");
        out.println("          <td>Cluster node A</td>");
        out.println("          <td>Node B</td>");
        out.println("          <td>Cluster node B</td>");
        out.println("          <td>Weight</td>");
        out.println("        </tr>");
        pairs = clusterSet.getClusterExternalPairs(clusterIndex);
        for (i = 0; i < pairs.size(); ++i) {
            pair = pairs.get(i);
            out.println("        <tr>");
            out.println("          <td>" + StringEscapeUtils.escapeHtml((String)clusterSet.getWholeNetwork().getNode(pair.getID().getElementA()).getProperties().getProperty("nodeName").getValue().toString()) + "</td>");
            int clusterOfNode = clusterSet.getClusterOfNode(pair.getID().getElementA());
            if (clusterOfNode != -1) {
                out.println("          <td>" + StringEscapeUtils.escapeHtml((String)clusterSet.getCluster(clusterOfNode).getProperties().getProperty("clusterName").toString()) + "</td>");
            } else {
                out.println("          <td></td>");
            }
            out.println("          <td>" + StringEscapeUtils.escapeHtml((String)clusterSet.getWholeNetwork().getNode(pair.getID().getElementB()).getProperties().getProperty("nodeName").getValue().toString()) + "</td>");
            clusterOfNode = clusterSet.getClusterOfNode(pair.getID().getElementB());
            if (clusterOfNode != -1) {
                out.println("          <td>" + StringEscapeUtils.escapeHtml((String)clusterSet.getCluster(clusterOfNode).getProperties().getProperty("clusterName").toString()) + "</td>");
            } else {
                out.println("          <td></td>");
            }
            out.println("          <td>" + this.numberFormatter.format(pair.getValue()) + "</td>");
            out.println("        </tr>");
        }
        out.println("      </table>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
    }

    public double maxPeriodNodeFrequency(WholeNetwork wholeNetwork) {
        double max = 0.0;
        ArrayList<Node> nodes = wholeNetwork.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            double tmp = (Double)nodes.get(i).getProperties().getProperty("nodeFrequency").getValue();
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    private void svgToFile(String path, String document) throws FileNotFoundException {
        PrintStream out = new PrintStream(path);
        out.println(document);
        out.close();
    }

    private boolean makeFolderStructure() {
        boolean successful = false;
        File file = new File(this.path + File.separator + __IMAGES_FOLDER_NAME);
        if (file.mkdirs()) {
            file = new File(this.path + File.separator + __MISC_FOLDER_NAME);
            return file.mkdirs();
        }
        return successful;
    }

    private String getFileAbsolutePathPeriodHTMLPage(int period) {
        return this.path + File.separator + this.getFilePathPeriodHTMLPage(period);
    }

    private String getFilePathPeriodHTMLPage(int period) {
        return "period" + period + ".html";
    }

    private String getFileAbsolutePathClusterHTMLPage(int period, int cluster) {
        return this.path + File.separator + this.getFilePathClusterHTMLPage(period, cluster);
    }

    private String getFilePathClusterHTMLPage(int period, int cluster) {
        return "period" + period + "-cluster" + cluster + ".html";
    }

    private String getFileAbsolutePathMainHTMLPage() {
        return this.path + File.separator + this.getFilePathMainHTMLPage();
    }

    private String getFilePathMainHTMLPage() {
        return "index.html";
    }

    private String getFileAbsolutePathStrategicDiagram(int period, String subName, String extension) {
        return this.path + File.separator + __IMAGES_FOLDER_NAME + File.separator + "strategicDiagram-period" + String.valueOf(period) + "-" + subName + "." + extension;
    }

    private String getFilePathStrategicDiagram(int period, String subName, String extension) {
        return __IMAGES_FOLDER_NAME + "/" + "strategicDiagram-period" + String.valueOf(period) + "-" + subName + "." + extension;
    }

    private String getFileAbsolutePathClusterNetwork(int period, int theme, String extension) {
        return this.path + File.separator + __IMAGES_FOLDER_NAME + File.separator + "clusterNetwork-period" + String.valueOf(period) + "-cluster" + String.valueOf(theme + 1) + "." + extension;
    }

    private String getFilePathClusterNetwork(int period, int theme, String extension) {
        return __IMAGES_FOLDER_NAME + "/" + "clusterNetwork-period" + String.valueOf(period) + "-cluster" + String.valueOf(theme + 1) + "." + extension;
    }

    private String getFileAbsolutePathOverlappingMap(String extension) {
        return this.path + File.separator + __IMAGES_FOLDER_NAME + File.separator + "overlappingMap" + "." + extension;
    }

    private String getFilePathOverlappingMap(String extension) {
        return __IMAGES_FOLDER_NAME + "/" + "overlappingMap" + "." + extension;
    }

    private String getFileAbsolutePathEvolutionMap(String subname, String extension) {
        return this.path + File.separator + __IMAGES_FOLDER_NAME + File.separator + "evolutionMap-" + subname + "." + extension;
    }

    private String getFilePathEvolutiongMap(String subname, String extension) {
        return __IMAGES_FOLDER_NAME + "/" + "evolutionMap-" + subname + "." + extension;
    }

    private String getFileAbsolutePathEvolutionMapPajek(String subname) {
        return this.path + File.separator + __MISC_FOLDER_NAME + File.separator + "evolutionMap-" + subname + ".net";
    }

    private String getFilePathEvolutiongMapPajek(String subname) {
        return __MISC_FOLDER_NAME + "/" + "evolutionMap-" + subname + ".net";
    }

    private String getFileAbsolutePathWholeNetworkPajek(int period) {
        return this.path + File.separator + __MISC_FOLDER_NAME + File.separator + "wholeNetwork-period" + String.valueOf(period) + ".net";
    }

    private String getFilePathWholeNetworkPajekm(int period) {
        return __MISC_FOLDER_NAME + "/" + "wholeNetwork-period" + String.valueOf(period) + ".net";
    }
}

